/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.ClientCloseListener;
import dev.bitbite.networking.ClientListener;
import dev.bitbite.networking.DataPreProcessor;
import dev.bitbite.networking.DisconnectedServerDetector;
import dev.bitbite.networking.IOHandler;
import dev.bitbite.networking.IOHandlerListener;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;

public abstract class Client {
    private boolean closed;
    public final String HOST;
    public final int PORT;
    protected Socket socket;
    private IOHandler iOHandler;
    private DataPreProcessor dataPreProcessor;
    protected DisconnectedServerDetector disconnectedServerDetector;
    private Thread readThread;
    private boolean keepAlive = false;
    private ArrayList<ClientListener> listeners;
    private ArrayList<IOHandlerListener> ioListeners;
    private static boolean VERBOSE = false;

    public Client(String host, int port) {
        this.HOST = host;
        this.PORT = port;
        this.listeners = new ArrayList();
        this.ioListeners = new ArrayList();
        this.dataPreProcessor = new DataPreProcessor();
        this.ioListeners.add(new ClientCloseListener(this));
        this.disconnectedServerDetector = new DisconnectedServerDetector(this);
        this.disconnectedServerDetector.setName("Disconnected Server Detector");
    }

    public Client(URL url) {
        this(url.getHost(), url.getPort());
    }

    public boolean connect() {
        try {
            this.notifyListeners(EventType.CONNECTION, new Object[0]);
            this.openSocket();
            this.iOHandler = new IOHandler(this.socket.getInputStream(), this.socket.getOutputStream(), this::preprocessReceivedData);
            this.ioListeners.forEach(l -> this.iOHandler.registerListener((IOHandlerListener)l));
            if (this.socket.isConnected()) {
                this.notifyListeners(EventType.CONNECTION_SUCCESS, new Object[0]);
                this.socket.setKeepAlive(this.keepAlive);
            }
            if (this.readThread != null) {
                this.readThread.interrupt();
            }
            this.readThread = new Thread(() -> {
                while (!Thread.interrupted()) {
                    this.iOHandler.read();
                }
                Thread.currentThread().interrupt();
            });
            this.readThread.setName("Data reader");
            this.readThread.start();
            this.disconnectedServerDetector.start();
        }
        catch (Exception e) {
            this.notifyListeners(EventType.CONNECTION_FAILED, e);
            return false;
        }
        return true;
    }

    protected void openSocket() throws UnknownHostException, IOException {
        this.socket = new Socket(this.HOST, this.PORT);
    }

    public boolean close() {
        try {
            this.notifyListeners(EventType.CLOSE, new Object[0]);
            this.readThread.interrupt();
            this.iOHandler.close();
            this.socket.close();
            this.disconnectedServerDetector.interrupt();
        }
        catch (Exception e) {
            this.notifyListeners(EventType.CLOSE_FAILED, e);
            return false;
        }
        this.notifyListeners(EventType.CLOSE_SUCCESS, new Object[0]);
        this.closed = true;
        return true;
    }

    public void send(byte[] data) {
        data = this.dataPreProcessor.process(DataPreProcessor.TransferMode.OUT, data);
        this.iOHandler.write(data);
    }

    protected void preprocessReceivedData(byte[] data) {
        this.processReceivedData(this.dataPreProcessor.process(DataPreProcessor.TransferMode.IN, data));
    }

    protected abstract void processReceivedData(byte[] var1);

    public void registerListener(ClientListener listener) {
        this.listeners.add(listener);
    }

    public void registerListener(IOHandlerListener listener) {
        this.ioListeners.add(listener);
        if (this.iOHandler != null) {
            this.iOHandler.registerListener(listener);
        }
    }

    public void removeListener(ClientListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void removeListener(IOHandlerListener listener) {
        if (this.ioListeners.contains(listener)) {
            this.ioListeners.remove(listener);
            this.iOHandler.removeListener(listener);
        }
    }

    private void notifyListeners(EventType type, Object ... args) {
        if (VERBOSE && args.length > 0 && args[0] instanceof Exception) {
            ((Exception)args[0]).printStackTrace();
        }
        switch (type) {
            case CONNECTION: {
                this.listeners.forEach(l -> l.onConnectionCreation());
                break;
            }
            case CONNECTION_SUCCESS: {
                this.listeners.forEach(l -> l.onConnectionSuccess());
                break;
            }
            case CONNECTION_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (!(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onConnectionFailed((Exception)args[0]));
                break;
            }
            case CLOSE: {
                this.listeners.forEach(l -> l.onCloseRequested());
                break;
            }
            case CLOSE_FAILED: {
                if (args.length == 0) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got nothing");
                }
                if (args.length == 0 || !(args[0] instanceof Exception)) {
                    throw new IllegalArgumentException("Expected object of type Exception, but got " + args[0].getClass().getSimpleName());
                }
                this.listeners.forEach(l -> l.onCloseFailed((Exception)args[0]));
                break;
            }
            case CLOSE_SUCCESS: {
                this.listeners.forEach(l -> l.onCloseSuccess());
                break;
            }
        }
    }

    public boolean isConnected() {
        if (this.socket == null || this.socket.isClosed()) {
            return false;
        }
        return this.socket.isConnected();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public IOHandler getIOHandler() {
        return this.iOHandler;
    }

    public DataPreProcessor getDataPreProcessor() {
        return this.dataPreProcessor;
    }

    public static boolean isVERBOSE() {
        return VERBOSE;
    }

    public static void setVERBOSE(boolean VERBOSE) {
        Client.VERBOSE = VERBOSE;
    }

    static enum EventType {
        CONNECTION,
        CONNECTION_SUCCESS,
        CONNECTION_FAILED,
        CLOSE,
        CLOSE_FAILED,
        CLOSE_SUCCESS;

    }
}

