/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.DataProcessingLayer;
import dev.bitbite.networking.exceptions.LayerDisableFailedException;
import dev.bitbite.networking.exceptions.LayerInitFailedException;
import java.util.ArrayList;

public class DataPreProcessor {
    private ArrayList<DataProcessingLayer> incomingDataProcessingLayers = new ArrayList();
    private ArrayList<DataProcessingLayer> outgoingDataProcessingLayers = new ArrayList();

    protected DataPreProcessor() {
    }

    protected byte[] process(TransferMode mode, byte[] data) {
        block3: {
            block2: {
                if (mode != TransferMode.IN) break block2;
                for (DataProcessingLayer layer : this.incomingDataProcessingLayers) {
                    data = layer.process(data);
                }
                break block3;
            }
            if (mode != TransferMode.OUT) break block3;
            for (DataProcessingLayer layer : this.outgoingDataProcessingLayers) {
                data = layer.process(data);
            }
        }
        return data;
    }

    public void initLayers() throws LayerInitFailedException {
        for (DataProcessingLayer l : this.incomingDataProcessingLayers) {
            if (l.onEnable()) continue;
            throw new LayerInitFailedException(l.getClass().getName());
        }
        for (DataProcessingLayer l : this.outgoingDataProcessingLayers) {
            if (l.onEnable()) continue;
            throw new LayerInitFailedException(l.getClass().getName());
        }
    }

    public void shutdown() throws LayerDisableFailedException {
        for (DataProcessingLayer l : this.incomingDataProcessingLayers) {
            if (l.onDisable()) continue;
            throw new LayerDisableFailedException(l.getClass().getName());
        }
        for (DataProcessingLayer l : this.outgoingDataProcessingLayers) {
            if (l.onDisable()) continue;
            throw new LayerDisableFailedException(l.getClass().getName());
        }
    }

    public void addLayer(TransferMode mode, DataProcessingLayer layer) {
        if (mode == TransferMode.IN) {
            this.incomingDataProcessingLayers.add(layer);
        }
        if (mode == TransferMode.OUT) {
            this.outgoingDataProcessingLayers.add(layer);
        }
    }

    public void addLayer(TransferMode mode, int index, DataProcessingLayer layer) {
        if (mode == TransferMode.IN) {
            this.incomingDataProcessingLayers.add(index, layer);
        }
        if (mode == TransferMode.OUT) {
            this.outgoingDataProcessingLayers.add(index, layer);
        }
    }

    public DataProcessingLayer getLayerAt(TransferMode mode, int index) {
        if (mode == TransferMode.IN) {
            return this.incomingDataProcessingLayers.get(index);
        }
        if (mode == TransferMode.OUT) {
            return this.outgoingDataProcessingLayers.get(index);
        }
        return null;
    }

    public void removeLayer(TransferMode mode, DataProcessingLayer layer) {
        if (mode == TransferMode.IN) {
            this.incomingDataProcessingLayers.remove(layer);
        }
        if (mode == TransferMode.OUT) {
            this.outgoingDataProcessingLayers.remove(layer);
        }
    }

    public ArrayList<DataProcessingLayer> getLayers(TransferMode mode) {
        if (mode == TransferMode.IN) {
            return this.incomingDataProcessingLayers;
        }
        if (mode == TransferMode.OUT) {
            return this.outgoingDataProcessingLayers;
        }
        return null;
    }

    public static enum TransferMode {
        IN,
        OUT;

    }
}

