/*
 * Decompiled with CFR 0.152.
 */
package dev.bitbite.networking;

import dev.bitbite.networking.CommunicationHandler;
import dev.bitbite.networking.Server;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DisconnectedClientDetector
extends Thread {
    private long MAX_READ_THRESHOLD = 5000000000L;
    private Server server;
    private ExecutorService executorService;

    public DisconnectedClientDetector(Server server) {
        this.server = server;
        this.executorService = Executors.newSingleThreadExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            for (CommunicationHandler ch : this.server.getClientManager().getCommunicationHandler()) {
                if (ch.getIOHandler().getTimeSinceLastRead() <= this.MAX_READ_THRESHOLD) continue;
                Future<Boolean> future = this.executorService.submit(() -> {
                    Thread.currentThread().setName("[DDC] client checker");
                    ch.getIOHandler().readNBytes(1);
                    return true;
                });
                try {
                    future.get(20L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    future.cancel(true);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Thread.currentThread().interrupt();
    }

    public void setMaxReadThreshold(long threshold) {
        this.MAX_READ_THRESHOLD = threshold;
    }
}

