/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArrayUtil {
    public static String toString(double[] array, int decimalPlaces) {
        return ArrayUtil.toString((Object)array, decimalPlaces);
    }

    public static String toString(float[] array, int decimalPlaces) {
        return ArrayUtil.toString((Object)array, decimalPlaces);
    }

    private static String toString(Object boxedFloats, int decimalPlaces) {
        String format = "%." + decimalPlaces + "f";
        if (boxedFloats == null) {
            return "null";
        }
        int iMax = Array.getLength(boxedFloats) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.format(format, Array.get(boxedFloats, i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String deepToStringFormatted(Object[] array) {
        String s = Arrays.deepToString(array);
        s = s.replaceAll("],", "]\n");
        return s;
    }

    public static String deepToString(Object[] array) {
        return Arrays.deepToString(array);
    }

    public static String toString(Object[] array) {
        return Arrays.toString(array);
    }

    @Deprecated
    private static String toDeepString(Object boxedFloats, int decimalPlaces) {
        String format = "%." + decimalPlaces + "f";
        if (boxedFloats == null) {
            return "null";
        }
        int iMax = Array.getLength(boxedFloats) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object elem;
            if ((elem = Array.get(boxedFloats, i)).getClass().isArray()) {
                b.append(ArrayUtil.toDeepString(elem, decimalPlaces));
            } else {
                b.append(String.format(format, elem));
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <T> T[] deepArrayCopy(T[] array) {
        if (0 >= array.length) {
            return array;
        }
        return (Object[])ArrayUtil.deepCopyOf(array, Array.newInstance(array[0].getClass(), array.length), 0);
    }

    @Deprecated
    public static <T> T[] deepArrayCopyClone(T[] array) throws Exception {
        if (0 >= array.length) {
            return array;
        }
        return (Object[])ArrayUtil.deepCloneCopyOf(array, Array.newInstance(array[0].getClass(), array.length), 0);
    }

    private static Object deepCopyOf(Object array, Object copiedArray, int index) {
        if (index >= Array.getLength(array)) {
            return copiedArray;
        }
        Object element = Array.get(array, index);
        if (element != null && element.getClass().isArray()) {
            Array.set(copiedArray, index, ArrayUtil.deepCopyOf(element, Array.newInstance(element.getClass().getComponentType(), Array.getLength(element)), 0));
        } else {
            Array.set(copiedArray, index, element);
        }
        return ArrayUtil.deepCopyOf(array, copiedArray, ++index);
    }

    @Deprecated
    private static Object deepCloneCopyOf(Object array, Object copiedArray, int index) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (index >= Array.getLength(array)) {
            return copiedArray;
        }
        Object element = Array.get(array, index);
        if (element == null) {
            Array.set(copiedArray, index, element);
        } else if (element.getClass().isArray()) {
            Array.set(copiedArray, index, ArrayUtil.deepCopyOf(element, Array.newInstance(element.getClass().getComponentType(), Array.getLength(element)), 0));
        } else if (element instanceof Cloneable) {
            Method clone = element.getClass().getMethod("clone", new Class[0]);
            Object cloned = clone.invoke(element, new Object[0]);
            Array.set(copiedArray, index, cloned);
        } else {
            Array.set(copiedArray, index, element);
        }
        return ArrayUtil.deepCopyOf(array, copiedArray, ++index);
    }

    public static boolean deepAllNotNull(Object[] array) {
        for (Object o : array) {
            if (o == null) {
                return false;
            }
            if (!o.getClass().isArray() || ArrayUtil.deepAllNotNull((Object[])o)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allNotNull(T[] array) {
        for (T t : array) {
            if (t != null) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allNull(T[] array) {
        for (T t : array) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    public static int twoDimtoOneDim(int x, int y, int width) {
        return x * width + y;
    }

    public static <T> void fillArray(T[] array, Supplier<T> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static <T> T fillArrayMulti(T array, Supplier<T> s) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s));
            }
        } else {
            return s.get();
        }
        return array;
    }

    public static <T> T fillArrayMulti(T array, Function<Integer, T> s) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s, i));
            }
        }
        return array;
    }

    private static <T> T fillArrayMulti(T array, Function<Integer, T> s, int index) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s, i));
            }
        } else {
            return s.apply(index);
        }
        return array;
    }

    public static void fillArray(boolean[] array, Supplier<Boolean> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(byte[] array, Supplier<Byte> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(char[] array, Supplier<Character> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get().charValue();
        }
    }

    public static void fillArray(short[] array, Supplier<Short> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(int[] array, Supplier<Integer> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(long[] array, Supplier<Long> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(float[] array, Supplier<Float> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get().floatValue();
        }
    }

    public static void fillArray(double[] array, Supplier<Double> s) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = s.get();
        }
    }

    public static void fillArray(boolean[] array, Function<Integer, Boolean> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static void fillArray(char[] array, Function<Integer, Character> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i).charValue();
        }
    }

    public static void fillArray(short[] array, Function<Integer, Short> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static void fillArray(int[] array, Function<Integer, Integer> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static void fillArray(long[] array, Function<Integer, Long> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static void fillArray(float[] array, Function<Integer, Float> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i).floatValue();
        }
    }

    public static void fillArray(double[] array, Function<Integer, Double> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static <T> void fillArray(T[] array, Function<Integer, T> supplier) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = supplier.apply(i);
        }
    }

    public static <T> int linearSearch(T[] array, T needle, int start, int stop) {
        int maxIndex = Math.min(array.length, stop);
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < maxIndex; ++i) {
            if (!array[i].equals(needle)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int linearSearch(T[] array, T needle) {
        return ArrayUtil.linearSearch(array, needle, 0, array.length);
    }

    public static <T> int frontBackSearch(T[] array, T needle, int from, int to) {
        --to;
        while (from <= to) {
            if (array[from].equals(needle)) {
                return from;
            }
            if (array[to].equals(needle)) {
                return to;
            }
            ++from;
            --to;
        }
        return -1;
    }

    public static <T> int frontBackSearch(T[] array, T needle) {
        return ArrayUtil.frontBackSearch(array, needle, 0, array.length);
    }

    public static int[] getSortedIndices(boolean[] array, boolean descending) {
        HashMap<Integer, Boolean> sorter = new HashMap<Integer, Boolean>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(byte[] array, boolean descending) {
        HashMap<Integer, Byte> sorter = new HashMap<Integer, Byte>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(char[] array, boolean descending) {
        HashMap<Integer, Character> sorter = new HashMap<Integer, Character>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, Character.valueOf(array[i]));
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(short[] array, boolean descending) {
        HashMap<Integer, Short> sorter = new HashMap<Integer, Short>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(int[] array, boolean descending) {
        HashMap<Integer, Integer> sorter = new HashMap<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(long[] array, boolean descending) {
        HashMap<Integer, Long> sorter = new HashMap<Integer, Long>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(float[] array, boolean descending) {
        HashMap<Integer, Float> sorter = new HashMap<Integer, Float>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, Float.valueOf(array[i]));
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(double[] array, boolean descending) {
        HashMap<Integer, Double> sorter = new HashMap<Integer, Double>();
        for (int i = 0; i < array.length; ++i) {
            sorter.put(i, array[i]);
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int minimumIndex(byte[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        byte min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(char[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        char min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(short[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        short min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(int[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(long[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        long min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static int minimumIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
            minIndex = i;
        }
        return minIndex;
    }

    public static byte minimum(byte[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static char minimum(char[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static short minimum(short[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static int minimum(int[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static long minimum(long[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static float minimum(float[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static double minimum(double[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static int maximumIndex(byte[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        byte max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(char[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        char max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(short[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(int[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(long[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        long max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        float max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maximumIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static byte maximum(byte[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static char maximum(char[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static short maximum(short[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static int maximum(int[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static long maximum(long[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static float maximum(float[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static double maximum(double[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static void add(byte[] arr, byte summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (byte)(arr[n] + summand);
        }
    }

    public static void add(char[] arr, char summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (char)(arr[n] + summand);
        }
    }

    public static void add(short[] arr, short summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (short)(arr[n] + summand);
        }
    }

    public static void add(int[] arr, int summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(long[] arr, long summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(float[] arr, float summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(double[] arr, double summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void subtract(byte[] arrMinuend, byte subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (byte)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(char[] arrMinuend, char subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (char)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(short[] arrMinuend, short subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (short)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(int[] arrMinuend, int subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(long[] arrMinuend, long subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(float[] arrMinuend, float subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(double[] arrMinuend, double subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void multiply(byte[] arr, byte factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (byte)(arr[n] * factor);
        }
    }

    public static void multiply(char[] arr, char factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (char)(arr[n] * factor);
        }
    }

    public static void multiply(short[] arr, short factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (short)(arr[n] * factor);
        }
    }

    public static void multiply(int[] arr, int factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(long[] arr, long factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(float[] arr, float factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(double[] arr, double factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void divide(byte[] arrDividend, byte divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (byte)(arrDividend[n] / divisor);
        }
    }

    public static void divide(char[] arrDividend, char divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (char)(arrDividend[n] / divisor);
        }
    }

    public static void divide(short[] arrDividend, short divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (short)(arrDividend[n] / divisor);
        }
    }

    public static void divide(int[] arrDividend, int divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(long[] arrDividend, long divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(float[] arrDividend, float divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(double[] arrDividend, double divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void multiply(byte[] arr, byte[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = (byte)(arr[n] * factors[i]);
        }
    }

    public static void multiply(char[] arr, char[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = (char)(arr[n] * factors[i]);
        }
    }

    public static void multiply(short[] arr, short[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = (short)(arr[n] * factors[i]);
        }
    }

    public static void multiply(int[] arr, int[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] * factors[i];
        }
    }

    public static void multiply(long[] arr, long[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] * factors[i];
        }
    }

    public static void multiply(float[] arr, float[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] * factors[i];
        }
    }

    public static void multiply(double[] arr, double[] factors) {
        for (int i = 0; i < arr.length; ++i) {
            int n = i;
            arr[n] = arr[n] * factors[i];
        }
    }

    public static void divide(byte[] arrDivisor, byte[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = (byte)(arrDivisor[n] / dividend[i]);
        }
    }

    public static void divide(char[] arrDivisor, char[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = (char)(arrDivisor[n] / dividend[i]);
        }
    }

    public static void divide(short[] arrDivisor, short[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = (short)(arrDivisor[n] / dividend[i]);
        }
    }

    public static void divide(int[] arrDivisor, int[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
        }
    }

    public static void divide(long[] arrDivisor, long[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
        }
    }

    public static void divide(float[] arrDivisor, float[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
        }
    }

    public static void divide(double[] arrDivisor, double[] dividend) {
        for (int i = 0; i < arrDivisor.length; ++i) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
        }
    }

    public static double average(byte[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (byte b : array) {
            avg += (double)b / numElem;
        }
        return avg;
    }

    public static double average(char[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (char c : array) {
            avg += (double)c / numElem;
        }
        return avg;
    }

    public static double average(short[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (short s : array) {
            avg += (double)s / numElem;
        }
        return avg;
    }

    public static double average(int[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (int i : array) {
            avg += (double)i / numElem;
        }
        return avg;
    }

    public static double average(long[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (long l : array) {
            avg += (double)l / numElem;
        }
        return avg;
    }

    public static double average(float[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (float f : array) {
            avg += (double)f / numElem;
        }
        return avg;
    }

    public static double average(double[] array) {
        double avg = 0.0;
        double numElem = array.length;
        for (double d : array) {
            avg += d / numElem;
        }
        return avg;
    }

    public static double average(byte[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(char[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(short[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(int[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(long[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(float[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double average(double[][] array) {
        double avg = 0.0;
        int w = array.length;
        for (int i = 0; i < w; ++i) {
            avg += ArrayUtil.average(array[i]) / (double)w;
        }
        return avg;
    }

    public static double median(byte[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(char[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(short[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(int[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(long[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(float[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(double[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static <T> T get(Object array, int ... index) {
        Object temp = array;
        for (int i = 0; i < index.length; ++i) {
            temp = Array.get(temp, index[i]);
        }
        return (T)temp;
    }
}

