/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.datastructures;

import java.io.Serializable;

public class Pair<S, U>
implements Serializable {
    private static final long serialVersionUID = 8525518254221383644L;
    private final S first;
    private final U second;

    public Pair(S first, U second) {
        this.first = first;
        this.second = second;
    }

    public Pair(Pair<? extends S, ? extends U> original) {
        this.first = original.first;
        this.second = original.second;
    }

    public S getFirst() {
        return this.first;
    }

    public U getSecond() {
        return this.second;
    }

    public String toString() {
        return "Pair [first=" + this.first + ", second=" + this.second + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }
}

