/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.MathUtil;
import dev.brachtendorf.graphics.FastPixelImpl;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class FastPixelInt
extends FastPixelImpl {
    private static final int FULL_ALPHA = -16777216;
    private int[] imageData;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private int alphaOffset;
    private int redOffset;
    private int blueOffset;
    private int greenOffset;

    public FastPixelInt(BufferedImage bImage) {
        super(bImage.getWidth(), bImage.getHeight());
        this.imageData = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        switch (bImage.getType()) {
            case 2: {
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
                this.alphaMask = -16777216;
                this.alpha = true;
                break;
            }
            case 1: {
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
                this.alphaMask = 0;
                break;
            }
            case 4: {
                this.redMask = 255;
                this.greenMask = 65280;
                this.blueMask = 0xFF0000;
                this.alphaMask = 0;
            }
        }
        this.redOffset = MathUtil.getLowerShiftBitMask(this.redMask);
        this.greenOffset = MathUtil.getLowerShiftBitMask(this.greenMask);
        this.blueOffset = MathUtil.getLowerShiftBitMask(this.blueMask);
        this.alphaOffset = MathUtil.getLowerShiftBitMask(this.alphaMask);
    }

    @Override
    public int getRGB(int index) {
        return (this.alpha ? this.getAlpha(index) << 24 : -16777216) | this.getRed(index) << 16 | this.getGreen(index) << 8 | this.getBlue(index);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.getRGB(this.getOffset(x, y));
    }

    @Override
    public int getAlphaInternal(int index) {
        if (!this.alpha) {
            return -1;
        }
        return (this.imageData[index] & this.alphaMask) >>> this.alphaOffset;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        if (!this.alpha) {
            return;
        }
        int n = index;
        this.imageData[n] = this.imageData[n] | newAlpha << this.alphaOffset;
    }

    @Override
    protected int getRedInternal(int index) {
        return (this.imageData[index] & this.redMask) >>> this.redOffset;
    }

    @Override
    public void setRed(int index, int newRed) {
        this.imageData[index] = this.imageData[index] & ~this.redMask | newRed << this.redOffset;
    }

    @Override
    public void setRed(int x, int y, int newRed) {
        this.setRed(this.getOffset(x, y), newRed);
    }

    @Override
    protected int getGreenInternal(int index) {
        return (this.imageData[index] & this.greenMask) >>> this.greenOffset;
    }

    @Override
    public void setGreen(int index, int newGreen) {
        this.imageData[index] = this.imageData[index] & ~this.greenMask | newGreen << this.greenOffset;
    }

    @Override
    protected int getBlueInternal(int index) {
        return (this.imageData[index] & this.blueMask) >>> this.blueOffset;
    }

    @Override
    public void setBlue(int index, int newBlue) {
        this.imageData[index] = this.imageData[index] & ~this.blueMask | newBlue << this.blueOffset;
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.width + x;
    }
}

