/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.graphics.ColorUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;
import javax.imageio.ImageTypeSpecifier;

public class ImageUtil {
    public static BufferedImage getScaledInstance(BufferedImage source, int width, int height) {
        BufferedImage target = ImageTypeSpecifier.createFromRenderedImage(source).createBufferedImage(width, height);
        Graphics g = target.getGraphics();
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnail(BufferedImage image, int newWidth, int newHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        boolean isTranslucent = true;
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics g2 = null;
        try {
            int previousWidth = width;
            int previousHeight = height;
            do {
                if (width > newWidth && (width /= 2) < newWidth) {
                    width = newWidth;
                }
                if (height > newHeight && (height /= 2) < newHeight) {
                    height = newHeight;
                }
                if (temp == null || isTranslucent) {
                    if (g2 != null) {
                        g2.dispose();
                    }
                    temp = new BufferedImage(width, height, 6);
                    g2 = temp.createGraphics();
                    ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
                previousWidth = width;
                previousHeight = height;
                thumb = temp;
            } while (width != newWidth || height != newHeight);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = new BufferedImage(width, height, 6);
            g2 = temp.createGraphics();
            try {
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.drawImage(thumb, 0, 0, width, height, 0, 0, width, height, null);
            }
            finally {
                g2.dispose();
            }
            thumb = temp;
        }
        return thumb;
    }

    public static BufferedImage toNewType(BufferedImage original, int newType) {
        BufferedImage bi = new BufferedImage(original.getWidth(), original.getHeight(), newType);
        Graphics g = bi.getGraphics();
        g.drawImage(original, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage toNewType(BufferedImage original, BImageType newType) {
        return ImageUtil.toNewType(original, newType.type);
    }

    public static Color interpolateColor(Image image) {
        BufferedImage bImage = SwingFXUtils.fromFXImage((Image)image, null);
        bImage = ImageUtil.getScaledInstance(bImage, 1, 1);
        int argb = bImage.getRGB(0, 0);
        return ColorUtil.argbToFXColor(argb);
    }

    public static Color dominantColor(Image image) {
        HashMap<Integer, Integer> colorCount = new HashMap<Integer, Integer>();
        PixelReader pr = image.getPixelReader();
        int[] pixels = new int[(int)(image.getWidth() * image.getHeight())];
        pr.getPixels(0, 0, (int)image.getWidth(), (int)image.getHeight(), PixelFormat.getIntArgbInstance(), pixels, 0, (int)image.getWidth());
        for (int argb : pixels) {
            Integer curValue = (Integer)colorCount.get(argb);
            colorCount.put(argb, curValue == null ? 1 : curValue + 1);
        }
        int argb = (Integer)((Map.Entry)colorCount.entrySet().stream().max((entry, entry2) -> ((Integer)entry.getValue()).compareTo((Integer)entry2.getValue())).get()).getKey();
        return ColorUtil.argbToFXColor(argb);
    }

    public static Color meanColor(Image image) {
        PixelReader pr = image.getPixelReader();
        int[] pixels = new int[(int)(image.getWidth() * image.getHeight())];
        pr.getPixels(0, 0, (int)image.getWidth(), (int)image.getHeight(), PixelFormat.getIntArgbInstance(), pixels, 0, (int)image.getWidth());
        double meanAlpha = 0.0;
        double meanRed = 0.0;
        double meanBlue = 0.0;
        double meanGreen = 0.0;
        int pixelCount = pixels.length;
        for (int argb : pixels) {
            int[] colorComponents = ColorUtil.argbToComponents(argb);
            meanAlpha += Math.pow(colorComponents[0], 2.0) / (double)pixelCount;
            meanRed += Math.pow(colorComponents[1], 2.0) / (double)pixelCount;
            meanGreen += Math.pow(colorComponents[2], 2.0) / (double)pixelCount;
            meanBlue += Math.pow(colorComponents[3], 2.0) / (double)pixelCount;
        }
        int argbMean = ColorUtil.componentsToARGB((int)Math.sqrt(meanAlpha) * 255, (int)Math.sqrt(meanRed), (int)Math.sqrt(meanGreen), (int)Math.sqrt(meanBlue));
        return ColorUtil.argbToFXColor(argbMean);
    }

    public static enum BImageType {
        TYPE_CUSTOM(0),
        TYPE_INT_RGB(1),
        TYPE_INT_ARGB(2),
        TYPE_INT_ARGB_PRE(3),
        TYPE_INT_BGR(4),
        TYPE_3BYTE_BGR(5),
        TYPE_4BYTE_ABGR(6),
        TYPE_4BYTE_ABGR_PRE(7),
        TYPE_USHORT_565_RGB(8),
        TYPE_USHORT_555_RGB(9),
        TYPE_BYTE_GRAY(10),
        TYPE_USHORT_GRAY(11),
        TYPE_BYTE_BINARY(12),
        TYPE_BYTE_INDEXED(13);

        private int type;

        private BImageType(int type) {
            this.type = type;
        }

        public int get() {
            return this.type;
        }
    }
}

