/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf;

public class MathUtil {
    public static int getLowerShiftBitMask(int mask) {
        int offset = 0;
        if (mask != 0) {
            while ((mask & 1) == 0) {
                mask >>= 1;
                ++offset;
            }
        } else {
            return -1;
        }
        return offset;
    }

    public static <T extends Number> T clampNumber(T value, T lowerBound, T upperBound) {
        if (((Comparable)((Object)value)).compareTo(lowerBound) <= 0) {
            return lowerBound;
        }
        if (((Comparable)((Object)value)).compareTo(upperBound) >= 0) {
            return upperBound;
        }
        return value;
    }

    public static long findClosestDivisibleInteger(int dividend, int divisor) {
        int n2;
        int quot = dividend / divisor;
        int n1 = divisor * quot;
        int n = n2 = dividend * divisor > 0 ? divisor * (quot + 1) : divisor * (quot - 1);
        if (Math.abs(dividend - n1) < Math.abs(dividend - n2)) {
            return n1;
        }
        return n2;
    }

    public static boolean isDoubleEquals(double needle, double target, double epsilon) {
        return Math.abs(needle - target) <= epsilon;
    }

    public static double getFractionalPart(double d) {
        return d - (double)((int)d);
    }

    public static double fitGaussian(double gaussian, double newStd, double newMean) {
        return gaussian * newStd + newMean;
    }

    public static double normalizeValue(double value, double observedMin, double observedMax, double newMin, double newMax) {
        return MathUtil.normalizeValue(value, observedMax - observedMin, observedMax, newMax - newMin, newMax, false);
    }

    public static double normalizeValue(double value, double observedRange, double observedMax, double newRange, double newMax, boolean dummy) {
        return newRange / observedRange * (value - observedMax) + newMax;
    }

    public static boolean isNumeric(Object var) {
        return var instanceof Number;
    }

    public static double log(double value, double base) {
        if (base == 0.0) {
            return Double.NaN;
        }
        return StrictMath.log(value) / StrictMath.log(base);
    }

    public static int triangularNumber(int n) {
        return n * (n + 1) / 2;
    }
}

