/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.clustering;

import com.github.kilianB.pcg.fast.PcgRSFast;
import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.clustering.KMeans;
import dev.brachtendorf.clustering.distance.DistanceFunction;
import java.util.DoubleSummaryStatistics;

public class KMeansPlusPlus
extends KMeans {
    public KMeansPlusPlus(int clusters) {
        super(clusters);
    }

    public KMeansPlusPlus(int clusters, DistanceFunction distanceFunction) {
        super(clusters, distanceFunction);
    }

    @Override
    protected DoubleSummaryStatistics[][] computeStartingClusters(double[][] data, int k, int dataDimension) {
        PcgRSFast rng = new PcgRSFast();
        DoubleSummaryStatistics[][] clusterMeans = new DoubleSummaryStatistics[k][dataDimension];
        ArrayUtil.fillArrayMulti(clusterMeans, () -> new DoubleSummaryStatistics());
        int clusterStart = rng.nextInt(data.length);
        for (int i = 0; i < dataDimension; ++i) {
            clusterMeans[0][i].accept(data[clusterStart][i]);
        }
        for (int cluster = 1; cluster < k; ++cluster) {
            double[] distance = new double[data.length];
            ArrayUtil.fillArray(distance, () -> Double.MAX_VALUE);
            double sum = 0.0;
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < cluster; ++j) {
                    double distTemp = this.distanceFunction.distanceSquared(clusterMeans[j], data[i]);
                    if (!(distTemp < distance[i])) continue;
                    distance[i] = distTemp;
                }
                sum += distance[i];
            }
            int index = 0;
            double rand = rng.nextDouble() * sum;
            for (double runningSum = distance[0]; index < data.length && !(rand <= runningSum); runningSum += distance[index], ++index) {
            }
            for (int i = 0; i < dataDimension; ++i) {
                clusterMeans[cluster][i].accept(data[i][i]);
            }
        }
        return clusterMeans;
    }
}

