/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.clustering.distance;

import dev.brachtendorf.clustering.distance.DistanceFunction;
import java.util.DoubleSummaryStatistics;

public class EuclideanDistance
implements DistanceFunction {
    @Override
    public double distance(DoubleSummaryStatistics[] v0, double[] v1) {
        return Math.sqrt(this.distanceSquared(v0, v1));
    }

    @Override
    public double distanceSquared(DoubleSummaryStatistics[] v0, double[] v1) {
        assert (v0.length == v1.length);
        double distance = 0.0;
        for (int i = 0; i < v0.length; ++i) {
            double temp = v0[i].getAverage() - v1[i];
            distance += temp * temp;
        }
        return distance;
    }

    @Override
    public double distance(double[] v0, double[] v1) {
        return Math.sqrt(this.distanceSquared(v0, v1));
    }

    @Override
    public double distanceSquared(double[] v0, double[] v1) {
        assert (v0.length == v1.length);
        double distance = 0.0;
        for (int i = 0; i < v0.length; ++i) {
            double temp = v0[i] - v1[i];
            distance += temp * temp;
        }
        return distance;
    }
}

