/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.datastructures;

import java.io.Serializable;

public class Triple<S, U, V>
implements Serializable {
    private static final long serialVersionUID = -6739318752459774954L;
    private final S first;
    private final U second;
    private final V third;

    public Triple(S first, U second, V third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public Triple(Triple<? extends S, ? extends U, ? extends V> original) {
        this.first = original.first;
        this.second = original.second;
        this.third = original.third;
    }

    public S getFirst() {
        return this.first;
    }

    public U getSecond() {
        return this.second;
    }

    public V getThird() {
        return this.third;
    }

    public String toString() {
        return "Triple [first=" + this.first + ", second=" + this.second + ", third=" + this.third + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.third == null ? 0 : this.third.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        return !(this.third == null ? other.third != null : !this.third.equals(other.third));
    }
}

