/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.graphics.ColorUtil;
import dev.brachtendorf.graphics.FastPixelByte;
import dev.brachtendorf.graphics.FastPixelInt;
import dev.brachtendorf.graphics.FastPixelSlowDefault;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javafx.scene.paint.Color;

public interface FastPixel {
    public static final Logger LOGGER = Logger.getLogger(FastPixel.class.getSimpleName());

    public static FastPixel create(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 5: 
            case 6: {
                return new FastPixelByte(bufferedImage);
            }
            case 1: 
            case 2: 
            case 4: {
                return new FastPixelInt(bufferedImage);
            }
        }
        LOGGER.finest("No fast implementation available for " + bufferedImage.getType() + ". Fallback to slow default variant.");
        return new FastPixelSlowDefault(bufferedImage);
    }

    public boolean isReplaceOpaqueColors();

    public void setReplaceOpaqueColors(int var1, int var2, int var3, int var4, int var5);

    default public void setReplaceOpaqueColors(int alphaThreshold, java.awt.Color replacementColor) {
        this.setReplaceOpaqueColors(alphaThreshold, replacementColor.getRed(), replacementColor.getGreen(), replacementColor.getBlue(), replacementColor.getAlpha());
    }

    default public void setReplaceOpaqueColors(int alphaThreshold, Color replacementColor) {
        this.setReplaceOpaqueColors(alphaThreshold, ColorUtil.fxToAwtColor(replacementColor));
    }

    public int getRGB(int var1);

    default public int getRGB(int x, int y) {
        return this.getRGB(this.getOffset(x, y));
    }

    public int[][] getRGB();

    public int getAlpha(int var1);

    default public int getAlpha(int x, int y) {
        return this.getAlpha(this.getOffset(x, y));
    }

    public int[][] getAlpha();

    default public void setAlpha(int x, int y, int newAlpha) {
        this.setAlpha(this.getOffset(x, y), newAlpha);
    }

    public void setAlpha(int var1, int var2);

    public void setAlpha(int[][] var1);

    public int getRed(int var1);

    default public int getRed(int x, int y) {
        return this.getRed(this.getOffset(x, y));
    }

    public int[][] getRed();

    public int[] getRed1D();

    default public void setRed(int x, int y, int newRed) {
        this.setRed(this.getOffset(x, y), newRed);
    }

    public void setRed(int var1, int var2);

    public void setRed(int[][] var1);

    public int getGreen(int var1);

    default public int getGreen(int x, int y) {
        return this.getGreen(this.getOffset(x, y));
    }

    default public void setGreen(int x, int y, int newGreen) {
        this.setGreen(this.getOffset(x, y), newGreen);
    }

    public void setGreen(int var1, int var2);

    public void setGreen(int[][] var1);

    public int[][] getGreen();

    public int[] getGreen1D();

    public int getBlue(int var1);

    default public int getBlue(int x, int y) {
        return this.getBlue(this.getOffset(x, y));
    }

    default public void setBlue(int x, int y, int newBlue) {
        this.setBlue(this.getOffset(x, y), newBlue);
    }

    public void setBlue(int var1, int var2);

    public int[][] getBlue();

    public int[] getBlue1D();

    public void setBlue(int[][] var1);

    public int getAverageGrayscale(int var1);

    default public int getAverageGrayscale(int x, int y) {
        return this.getAverageGrayscale(this.getOffset(x, y));
    }

    public int[][] getAverageGrayscale();

    default public void setAverageGrayscale(int index, int newGrayValue) {
        this.setGreen(index, newGrayValue);
        this.setRed(index, newGrayValue);
        this.setBlue(index, newGrayValue);
    }

    default public void setAverageGrayscale(int x, int y, int newGrayValue) {
        this.setAverageGrayscale(this.getOffset(x, y), newGrayValue);
    }

    public void setAverageGrayscale(int[][] var1);

    default public int getLuma(int index) {
        int lum = (int)((double)this.getRed(index) * 0.299 + (double)this.getGreen(index) * 0.587 + (double)this.getBlue(index) * 0.114);
        return lum > 255 ? 255 : lum;
    }

    default public int getLuma(int x, int y) {
        return this.getLuma(this.getOffset(x, y));
    }

    public int[][] getLuma();

    public int[] getLuma1D();

    default public int getCr(int index) {
        int cr = (int)((double)this.getRed(index) * 0.5 + (double)this.getGreen(index) * 0.418688 + (double)this.getBlue(index) * 0.081312);
        return cr > 255 ? 255 : cr;
    }

    default public int getCr(int x, int y) {
        return this.getCr(this.getOffset(x, y));
    }

    default public int getCb(int index) {
        int cb = (int)((double)this.getRed(index) * 0.168736 + (double)this.getGreen(index) * 0.331264 + (double)this.getBlue(index) * 0.5);
        return cb > 255 ? 255 : cb;
    }

    default public int getCb(int x, int y) {
        return this.getCb(this.getOffset(x, y));
    }

    default public int getHue(int index) {
        int blue = this.getBlue(index);
        int green = this.getGreen(index);
        int red = this.getRed(index);
        int min = Math.min(blue, Math.min(green, red));
        int max = Math.max(blue, Math.max(green, red));
        if (max == min) {
            return 0;
        }
        double range = max - min;
        double h = red == max ? 60.0 * ((double)(green - blue) / range) : (green == max ? 60.0 * (2.0 + (double)(blue - red) / range) : 60.0 * (4.0 + (double)(red - green) / range));
        int hue = (int)Math.round(h);
        if (hue < 0) {
            hue += 360;
        }
        return hue;
    }

    default public int getHue(int x, int y) {
        return this.getHue(this.getOffset(x, y));
    }

    default public double getSat(int index) {
        int red;
        int green;
        int blue = this.getBlue(index);
        int max = Math.max(blue, Math.max(green = this.getGreen(index), red = this.getRed(index)));
        if (max == 0) {
            return 0.0;
        }
        int min = Math.min(blue, Math.min(green, red));
        return (double)(max - min) / (double)max;
    }

    default public double getSat(int x, int y) {
        return this.getSat(this.getOffset(x, y));
    }

    default public int getVal(int index) {
        int blue = this.getBlue(index);
        int green = this.getGreen(index);
        int red = this.getRed(index);
        int max = Math.max(blue, Math.max(green, red));
        return max;
    }

    default public int getVal(int x, int y) {
        return this.getVal(this.getOffset(x, y));
    }

    public boolean hasAlpha();

    public int getOffset(int var1, int var2);
}

