/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.graphics.FastPixelImpl;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class FastPixelByte
extends FastPixelImpl {
    private static final int ALPHA_MASK = -16777216;
    private final int alphaOffset;
    private final int bytesPerColor;
    private final byte[] imageData;

    public FastPixelByte(BufferedImage bImage) {
        super(bImage.getWidth(), bImage.getHeight());
        this.imageData = ((DataBufferByte)bImage.getRaster().getDataBuffer()).getData();
        if (bImage.getColorModel().hasAlpha()) {
            this.alphaOffset = 1;
            this.alpha = true;
            this.bytesPerColor = 4;
        } else {
            this.alphaOffset = 0;
            this.alpha = false;
            this.bytesPerColor = 3;
        }
    }

    @Override
    public int getRGB(int index) {
        return (this.alpha ? this.getAlpha(index) << 24 : -16777216) | this.getRed(index) << 16 | this.getGreen(index) << 8 | this.getBlue(index);
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.imageData.length; i += this.bytesPerColor) {
            int argb;
            rgb[x][y] = argb = this.getRGB(i);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return rgb;
    }

    @Override
    public int[][] getAlpha() {
        if (!this.alpha) {
            return null;
        }
        int[][] alpha = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.imageData.length; i += this.bytesPerColor) {
            alpha[x][y] = this.getAlpha(i);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return alpha;
    }

    @Override
    public int getAlphaInternal(int index) {
        if (!this.alpha) {
            return -1;
        }
        return this.imageData[index] & 0xFF;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        if (!this.alpha) {
            return;
        }
        this.imageData[index] = (byte)newAlpha;
    }

    @Override
    public int getRedInternal(int index) {
        return this.imageData[index + this.alphaOffset + 2] & 0xFF;
    }

    @Override
    public void setRed(int index, int newRed) {
        this.imageData[index + this.alphaOffset + 2] = (byte)newRed;
    }

    @Override
    public int getGreenInternal(int index) {
        return this.imageData[index + this.alphaOffset + 1] & 0xFF;
    }

    @Override
    public void setGreen(int index, int newGreen) {
        this.imageData[index + this.alphaOffset + 1] = (byte)newGreen;
    }

    @Override
    public int getBlueInternal(int index) {
        return this.imageData[index + this.alphaOffset] & 0xFF;
    }

    @Override
    public void setBlue(int index, int newBlue) {
        this.imageData[index + this.alphaOffset] = (byte)newBlue;
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.bytesPerColor * this.width + x * this.bytesPerColor;
    }

    @Override
    public int[] getLuma1D() {
        int[] luma = new int[this.width * this.height];
        int i = 0;
        int j = 0;
        while (i < this.imageData.length) {
            luma[j] = this.getLuma(i);
            i += this.bytesPerColor;
            ++j;
        }
        return luma;
    }

    @Override
    public int[] getRed1D() {
        int[] red = new int[this.width * this.height];
        int j = 0;
        int i = 0;
        while (i < this.imageData.length) {
            red[j] = this.getRed(i);
            i += this.bytesPerColor;
            ++j;
        }
        return red;
    }

    @Override
    public int[] getGreen1D() {
        int[] green = new int[this.width * this.height];
        int j = 0;
        int i = 0;
        while (i < this.imageData.length) {
            green[j] = this.getGreen(i);
            i += this.bytesPerColor;
            ++j;
        }
        return green;
    }

    @Override
    public int[] getBlue1D() {
        int[] blue = new int[this.width * this.height];
        int j = 0;
        int i = 0;
        while (i < this.imageData.length) {
            blue[j] = this.getBlue(i);
            i += this.bytesPerColor;
            ++j;
        }
        return blue;
    }
}

