/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.graphics.FastPixel;

public abstract class FastPixelImpl
implements FastPixel {
    protected final int width;
    protected final int height;
    protected boolean alpha = false;
    protected int alphaReplacementThreshold = -1;
    protected int replacementR = -1;
    protected int replacementG = -1;
    protected int replacementB = -1;
    protected int replacementA = -1;

    @Override
    public boolean isReplaceOpaqueColors() {
        return this.alphaReplacementThreshold >= 0;
    }

    @Override
    public void setReplaceOpaqueColors(int alphaThreshold, int r, int g, int b, int a) {
        this.alphaReplacementThreshold = alphaThreshold;
        this.replacementR = r;
        this.replacementG = g;
        this.replacementB = b;
        this.replacementA = a;
    }

    public FastPixelImpl(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int[] getRed1D() {
        int[] red = new int[this.width * this.height];
        ArrayUtil.fillArray(red, i -> this.getRed((int)i));
        return red;
    }

    @Override
    public int[] getBlue1D() {
        int[] blue = new int[this.width * this.height];
        ArrayUtil.fillArray(blue, i -> this.getBlue((int)i));
        return blue;
    }

    @Override
    public int[] getGreen1D() {
        int[] green = new int[this.width * this.height];
        ArrayUtil.fillArray(green, i -> this.getGreen((int)i));
        return green;
    }

    @Override
    public int[] getLuma1D() {
        int[] luma = new int[this.width * this.height];
        ArrayUtil.fillArray(luma, i -> this.getLuma((int)i));
        return luma;
    }

    @Override
    public int getAverageGrayscale(int index) {
        return (this.getRed(index) + this.getGreen(index) + this.getBlue(index)) / 3;
    }

    @Override
    public int getLuma(int index) {
        int b;
        int g;
        int r = this.getRed(index);
        int lum = (int)((double)r * 0.299 + (double)(g = this.getGreen(index)) * 0.587 + (double)(b = this.getBlue(index)) * 0.114);
        return lum > 255 ? 255 : lum;
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            rgb[x][y] = this.getRGB(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return rgb;
    }

    @Override
    public int[][] getRed() {
        int[][] red = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            red[x][y] = this.getRed(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return red;
    }

    @Override
    public int[][] getGreen() {
        int[][] green = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            green[x][y] = this.getGreen(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return green;
    }

    @Override
    public int[][] getBlue() {
        int[][] blue = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            blue[x][y] = this.getBlue(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return blue;
    }

    @Override
    public int[][] getAlpha() {
        if (!this.hasAlpha()) {
            return null;
        }
        int[][] alpha = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            alpha[x][y] = this.getAlpha(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return alpha;
    }

    @Override
    public int[][] getLuma() {
        int[][] luma = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            luma[x][y] = this.getLuma(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return luma;
    }

    @Override
    public int[][] getAverageGrayscale() {
        int[][] gray = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            gray[x][y] = this.getAverageGrayscale(x, y);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return gray;
    }

    @Override
    public void setAlpha(int[][] newAlpha) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setAlpha(x, y, newAlpha[x][y]);
            }
        }
    }

    @Override
    public void setRed(int[][] newRed) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setRed(x, y, newRed[x][y]);
            }
        }
    }

    @Override
    public void setGreen(int[][] newGreen) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setGreen(x, y, newGreen[x][y]);
            }
        }
    }

    @Override
    public void setBlue(int[][] newBlue) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setBlue(x, y, newBlue[x][y]);
            }
        }
    }

    @Override
    public void setAverageGrayscale(int[][] newGrayValue) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.setAverageGrayscale(x, y, newGrayValue[x][y]);
            }
        }
    }

    @Override
    public final int getRed(int offset) {
        if (this.hasAlpha() && this.isReplaceOpaqueColors() && this.getAlphaInternal(offset) <= this.alphaReplacementThreshold) {
            return this.replacementR;
        }
        return this.getRedInternal(offset);
    }

    @Override
    public final int getGreen(int offset) {
        if (this.hasAlpha() && this.isReplaceOpaqueColors() && this.getAlphaInternal(offset) <= this.alphaReplacementThreshold) {
            return this.replacementG;
        }
        return this.getGreenInternal(offset);
    }

    @Override
    public final int getBlue(int offset) {
        if (this.hasAlpha() && this.isReplaceOpaqueColors() && this.getAlphaInternal(offset) <= this.alphaReplacementThreshold) {
            return this.replacementB;
        }
        return this.getBlueInternal(offset);
    }

    @Override
    public final int getAlpha(int offset) {
        if (this.hasAlpha() && this.isReplaceOpaqueColors() && this.getAlphaInternal(offset) <= this.alphaReplacementThreshold) {
            return this.replacementA;
        }
        return this.getAlphaInternal(offset);
    }

    protected abstract int getRedInternal(int var1);

    protected abstract int getGreenInternal(int var1);

    protected abstract int getBlueInternal(int var1);

    protected abstract int getAlphaInternal(int var1);

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }
}

