/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.graphics;

import dev.brachtendorf.graphics.FastPixelImpl;
import java.awt.image.BufferedImage;

public class FastPixelSlowDefault
extends FastPixelImpl {
    private static final int FULL = -1;
    private static final int ALPHA_MASK = -16777216;
    private static final int ALPHA_MASK_INVERSE = 0xFFFFFF;
    private static final int RED_MASK = 0xFF0000;
    private static final int RED_MASK_INVERSE = -16711681;
    private static final int GREEN_MASK = 65280;
    private static final int GREEN_MASK_INVERSE = -65281;
    private static final int BLUE_MASK = 255;
    private static final int BLUE_MASK_INVERSE = -256;
    private final int[] rgbImageData;
    private BufferedImage bImage;

    public FastPixelSlowDefault(BufferedImage bImage) {
        super(bImage.getWidth(), bImage.getHeight());
        this.alpha = bImage.getColorModel().hasAlpha();
        this.rgbImageData = bImage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
    }

    @Override
    public int getRGB(int index) {
        if (this.alpha && this.isReplaceOpaqueColors() && this.getAlphaInternal(index) <= this.alphaReplacementThreshold) {
            return this.replacementA << 24 | this.replacementR << 16 | this.replacementG << 8 | this.replacementB;
        }
        return this.rgbImageData[index];
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.rgbImageData.length; ++i) {
            rgb[x][y] = this.getRGB(i);
            if (++x < this.width) continue;
            x = 0;
            ++y;
        }
        return rgb;
    }

    @Override
    public int getAlphaInternal(int index) {
        if (!this.alpha) {
            return -1;
        }
        return (this.rgbImageData[index] & 0xFF000000) >>> 24;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF | newAlpha << 24;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setAlpha(int[][] newAlpha) {
        for (int x = 0; x < newAlpha.length; ++x) {
            for (int y = 0; y < newAlpha[x].length; ++y) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF | newAlpha[x][y] << 24;
            }
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getRedInternal(int index) {
        return (this.rgbImageData[index] & 0xFF0000) >>> 16;
    }

    @Override
    public void setRed(int index, int newRed) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFF00FFFF | newRed << 16;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setRed(int[][] newRed) {
        for (int x = 0; x < newRed.length; ++x) {
            for (int y = 0; y < newRed[x].length; ++y) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFF00FFFF | newRed[x][y] << 16;
            }
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getGreenInternal(int index) {
        return (this.rgbImageData[index] & 0xFF00) >>> 8;
    }

    @Override
    public void setGreen(int index, int newGreen) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFF00FF | newGreen << 8;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setGreen(int[][] newGreen) {
        for (int x = 0; x < newGreen.length; ++x) {
            for (int y = 0; y < newGreen[x].length; ++y) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFF00FF | newGreen[x][y] << 8;
            }
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getBlueInternal(int index) {
        return this.rgbImageData[index] & 0xFF;
    }

    @Override
    public void setBlue(int index, int newBlue) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF00 | newBlue;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setBlue(int[][] newBlue) {
        for (int x = 0; x < newBlue.length; ++x) {
            for (int y = 0; y < newBlue[x].length; ++y) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF00 | newBlue[x][y];
            }
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public void setAverageGrayscale(int[][] newGrayValue) {
        super.setAverageGrayscale(newGrayValue);
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.width + x;
    }

    private int getX(int index) {
        return index % this.width;
    }

    private int getY(int index) {
        return index / this.width;
    }
}

