package dev.cel.common.ast;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_CelReference extends CelReference {

  private final String name;

  private final ImmutableList<String> overloadIds;

  private final Optional<CelConstant> value;

  private AutoValue_CelReference(
      String name,
      ImmutableList<String> overloadIds,
      Optional<CelConstant> value) {
    this.name = name;
    this.overloadIds = overloadIds;
    this.value = value;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public ImmutableList<String> overloadIds() {
    return overloadIds;
  }

  @Override
  public Optional<CelConstant> value() {
    return value;
  }

  @Override
  public String toString() {
    return "CelReference{"
        + "name=" + name + ", "
        + "overloadIds=" + overloadIds + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CelReference) {
      CelReference that = (CelReference) o;
      return this.name.equals(that.name())
          && this.overloadIds.equals(that.overloadIds())
          && this.value.equals(that.value());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= overloadIds.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  static final class Builder extends CelReference.Builder {
    private String name;
    private ImmutableList.Builder<String> overloadIdsBuilder$;
    private ImmutableList<String> overloadIds;
    private Optional<CelConstant> value = Optional.empty();
    Builder() {
    }
    @Override
    public CelReference.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    ImmutableList.Builder<String> overloadIdsBuilder() {
      if (overloadIdsBuilder$ == null) {
        overloadIdsBuilder$ = ImmutableList.builder();
      }
      return overloadIdsBuilder$;
    }
    @Override
    ImmutableList<String> overloadIds() {
      if (overloadIdsBuilder$ != null) {
        return overloadIdsBuilder$.build();
      }
      if (overloadIds == null) {
        overloadIds = ImmutableList.of();
      }
      return overloadIds;
    }
    @Override
    public CelReference.Builder setValue(CelConstant value) {
      this.value = Optional.of(value);
      return this;
    }
    @Override
    Optional<CelConstant> value() {
      return value;
    }
    @Override
    CelReference autoBuild() {
      if (overloadIdsBuilder$ != null) {
        this.overloadIds = overloadIdsBuilder$.build();
      } else if (this.overloadIds == null) {
        this.overloadIds = ImmutableList.of();
      }
      if (this.name == null) {
        String missing = " name";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CelReference(
          this.name,
          this.overloadIds,
          this.value);
    }
  }

}
