package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import dev.cel.common.annotations.Internal;
import java.util.Arrays;

@Internal
@SuppressWarnings("Immutable")
// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_BasicCodePointArray extends BasicCodePointArray {

  private final int size;

  private final ImmutableList<Integer> lineOffsets;

  private final char[] codePoints;

  private final int offset;

  AutoValue_BasicCodePointArray(
      int size,
      ImmutableList<Integer> lineOffsets,
      char[] codePoints,
      int offset) {
    this.size = size;
    if (lineOffsets == null) {
      throw new NullPointerException("Null lineOffsets");
    }
    this.lineOffsets = lineOffsets;
    if (codePoints == null) {
      throw new NullPointerException("Null codePoints");
    }
    this.codePoints = codePoints;
    this.offset = offset;
  }

  @Override
  public int size() {
    return size;
  }

  @Override
  public ImmutableList<Integer> lineOffsets() {
    return lineOffsets;
  }

  @SuppressWarnings("mutable")
  @Override
  char[] codePoints() {
    return codePoints;
  }

  @Override
  int offset() {
    return offset;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BasicCodePointArray) {
      BasicCodePointArray that = (BasicCodePointArray) o;
      return this.size == that.size()
          && this.lineOffsets.equals(that.lineOffsets())
          && Arrays.equals(this.codePoints, (that instanceof AutoValue_BasicCodePointArray) ? ((AutoValue_BasicCodePointArray) that).codePoints : that.codePoints())
          && this.offset == that.offset();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= size;
    h$ *= 1000003;
    h$ ^= lineOffsets.hashCode();
    h$ *= 1000003;
    h$ ^= Arrays.hashCode(codePoints);
    h$ *= 1000003;
    h$ ^= offset;
    return h$;
  }

}
