package dev.cel.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.CelCodePointArray;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_CelSource extends CelSource {

  private final CelCodePointArray codePoints;

  private final String description;

  private final ImmutableList<Integer> lineOffsets;

  private final ImmutableMap<Long, Integer> positions;

  private final ImmutableMap<Long, CelExpr> macroCalls;

  private final ImmutableSet<CelSource.Extension> extensions;

  AutoValue_CelSource(
      CelCodePointArray codePoints,
      String description,
      ImmutableList<Integer> lineOffsets,
      ImmutableMap<Long, Integer> positions,
      ImmutableMap<Long, CelExpr> macroCalls,
      ImmutableSet<CelSource.Extension> extensions) {
    if (codePoints == null) {
      throw new NullPointerException("Null codePoints");
    }
    this.codePoints = codePoints;
    if (description == null) {
      throw new NullPointerException("Null description");
    }
    this.description = description;
    if (lineOffsets == null) {
      throw new NullPointerException("Null lineOffsets");
    }
    this.lineOffsets = lineOffsets;
    if (positions == null) {
      throw new NullPointerException("Null positions");
    }
    this.positions = positions;
    if (macroCalls == null) {
      throw new NullPointerException("Null macroCalls");
    }
    this.macroCalls = macroCalls;
    if (extensions == null) {
      throw new NullPointerException("Null extensions");
    }
    this.extensions = extensions;
  }

  @Override
  CelCodePointArray codePoints() {
    return codePoints;
  }

  @Override
  String description() {
    return description;
  }

  @Override
  ImmutableList<Integer> lineOffsets() {
    return lineOffsets;
  }

  @Override
  ImmutableMap<Long, Integer> positions() {
    return positions;
  }

  @Override
  ImmutableMap<Long, CelExpr> macroCalls() {
    return macroCalls;
  }

  @Override
  ImmutableSet<CelSource.Extension> extensions() {
    return extensions;
  }

  @Override
  public String toString() {
    return "CelSource{"
        + "codePoints=" + codePoints + ", "
        + "description=" + description + ", "
        + "lineOffsets=" + lineOffsets + ", "
        + "positions=" + positions + ", "
        + "macroCalls=" + macroCalls + ", "
        + "extensions=" + extensions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CelSource) {
      CelSource that = (CelSource) o;
      return this.codePoints.equals(that.codePoints())
          && this.description.equals(that.description())
          && this.lineOffsets.equals(that.lineOffsets())
          && this.positions.equals(that.positions())
          && this.macroCalls.equals(that.macroCalls())
          && this.extensions.equals(that.extensions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= codePoints.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= lineOffsets.hashCode();
    h$ *= 1000003;
    h$ ^= positions.hashCode();
    h$ *= 1000003;
    h$ ^= macroCalls.hashCode();
    h$ *= 1000003;
    h$ ^= extensions.hashCode();
    return h$;
  }

}
