package dev.cel.common.ast;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_CelExpr_CelCall extends CelExpr.CelCall {

  private final Optional<CelExpr> target;

  private final String function;

  private final ImmutableList<CelExpr> args;

  private AutoValue_CelExpr_CelCall(
      Optional<CelExpr> target,
      String function,
      ImmutableList<CelExpr> args) {
    this.target = target;
    this.function = function;
    this.args = args;
  }

  @Override
  public Optional<CelExpr> target() {
    return target;
  }

  @Override
  public String function() {
    return function;
  }

  @Override
  public ImmutableList<CelExpr> args() {
    return args;
  }

  @Override
  public String toString() {
    return "CelCall{"
        + "target=" + target + ", "
        + "function=" + function + ", "
        + "args=" + args
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CelExpr.CelCall) {
      CelExpr.CelCall that = (CelExpr.CelCall) o;
      return this.target.equals(that.target())
          && this.function.equals(that.function())
          && this.args.equals(that.args());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= target.hashCode();
    h$ *= 1000003;
    h$ ^= function.hashCode();
    h$ *= 1000003;
    h$ ^= args.hashCode();
    return h$;
  }

  @Override
  CelExpr.CelCall.Builder autoToBuilder() {
    return new AutoValue_CelExpr_CelCall.Builder(this);
  }

  static final class Builder extends CelExpr.CelCall.Builder {
    private Optional<CelExpr> target = Optional.empty();
    private String function;
    private ImmutableList<CelExpr> args;
    Builder() {
    }
    Builder(CelExpr.CelCall source) {
      this.target = source.target();
      this.function = source.function();
      this.args = source.args();
    }
    @Override
    public CelExpr.CelCall.Builder setTarget(CelExpr target) {
      this.target = Optional.of(target);
      return this;
    }
    @Override
    public CelExpr.CelCall.Builder setTarget(Optional<CelExpr> target) {
      if (target == null) {
        throw new NullPointerException("Null target");
      }
      this.target = target;
      return this;
    }
    @Override
    public Optional<CelExpr> target() {
      return target;
    }
    @Override
    public CelExpr.CelCall.Builder setFunction(String function) {
      if (function == null) {
        throw new NullPointerException("Null function");
      }
      this.function = function;
      return this;
    }
    @Override
    CelExpr.CelCall.Builder setArgs(ImmutableList<CelExpr> args) {
      if (args == null) {
        throw new NullPointerException("Null args");
      }
      this.args = args;
      return this;
    }
    @Override
    ImmutableList<CelExpr> args() {
      if (this.args == null) {
        throw new IllegalStateException("Property \"args\" has not been set");
      }
      return args;
    }
    @Override
    CelExpr.CelCall autoBuild() {
      if (this.function == null
          || this.args == null) {
        StringBuilder missing = new StringBuilder();
        if (this.function == null) {
          missing.append(" function");
        }
        if (this.args == null) {
          missing.append(" args");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CelExpr_CelCall(
          this.target,
          this.function,
          this.args);
    }
  }

}
