package dev.cel.common.internal;

import com.google.common.collect.ImmutableList;
import dev.cel.common.annotations.Internal;
import java.util.Arrays;

@Internal
@SuppressWarnings("Immutable")
// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_SupplementalCodePointArray extends SupplementalCodePointArray {

  private final int size;

  private final ImmutableList<Integer> lineOffsets;

  private final int[] codePoints;

  private final int offset;

  AutoValue_SupplementalCodePointArray(
      int size,
      ImmutableList<Integer> lineOffsets,
      int[] codePoints,
      int offset) {
    this.size = size;
    if (lineOffsets == null) {
      throw new NullPointerException("Null lineOffsets");
    }
    this.lineOffsets = lineOffsets;
    if (codePoints == null) {
      throw new NullPointerException("Null codePoints");
    }
    this.codePoints = codePoints;
    this.offset = offset;
  }

  @Override
  public int size() {
    return size;
  }

  @Override
  public ImmutableList<Integer> lineOffsets() {
    return lineOffsets;
  }

  @SuppressWarnings("mutable")
  @Override
  int[] codePoints() {
    return codePoints;
  }

  @Override
  int offset() {
    return offset;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SupplementalCodePointArray) {
      SupplementalCodePointArray that = (SupplementalCodePointArray) o;
      return this.size == that.size()
          && this.lineOffsets.equals(that.lineOffsets())
          && Arrays.equals(this.codePoints, (that instanceof AutoValue_SupplementalCodePointArray) ? ((AutoValue_SupplementalCodePointArray) that).codePoints : that.codePoints())
          && this.offset == that.offset();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= size;
    h$ *= 1000003;
    h$ ^= lineOffsets.hashCode();
    h$ *= 1000003;
    h$ ^= Arrays.hashCode(codePoints);
    h$ *= 1000003;
    h$ ^= offset;
    return h$;
  }

}
