package dev.cel.common.values;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.MessageLite;
import dev.cel.common.types.CelType;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;

final class AutoValue_ProtoMessageLiteValue extends $AutoValue_ProtoMessageLiteValue {
  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<String, Object> fieldValues;

  AutoValue_ProtoMessageLiteValue(MessageLite value, CelType celType,
      ProtoLiteCelValueConverter protoLiteCelValueConverter) {
    super(value, celType, protoLiteCelValueConverter);
  }

  @Override
  ImmutableMap<String, Object> fieldValues() {
    if (fieldValues == null) {
      synchronized (this) {
        if (fieldValues == null) {
          fieldValues = super.fieldValues();
          if (fieldValues == null) {
            throw new NullPointerException("fieldValues() cannot return null");
          }
        }
      }
    }
    return fieldValues;
  }
}
