/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.internal.CelCodePointArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Immutable
public final class CelSource {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final CelCodePointArray codePoints;
    private final String description;
    private final ImmutableList<Integer> lineOffsets;
    private final ImmutableMap<Long, Integer> positions;
    private final ImmutableMap<Long, CelExpr> macroCalls;

    private CelSource(Builder builder) {
        this.codePoints = (CelCodePointArray)Preconditions.checkNotNull((Object)builder.codePoints);
        this.description = (String)Preconditions.checkNotNull((Object)builder.description);
        this.positions = (ImmutableMap)Preconditions.checkNotNull((Object)builder.positions.buildOrThrow());
        this.lineOffsets = (ImmutableList)Preconditions.checkNotNull((Object)ImmutableList.copyOf((Collection)builder.lineOffsets));
        this.macroCalls = (ImmutableMap)Preconditions.checkNotNull((Object)ImmutableMap.copyOf((Map)builder.macroCalls));
    }

    public CelCodePointArray getContent() {
        return this.codePoints;
    }

    public String getDescription() {
        return this.description;
    }

    public ImmutableMap<Long, Integer> getPositionsMap() {
        return this.positions;
    }

    public ImmutableList<Integer> getLineOffsets() {
        return this.lineOffsets;
    }

    public ImmutableMap<Long, CelExpr> getMacroCalls() {
        return this.macroCalls;
    }

    public Optional<Integer> getLocationOffset(CelSourceLocation location) {
        Preconditions.checkNotNull((Object)location);
        return this.getLocationOffset(location.getLine(), location.getColumn());
    }

    public Optional<Integer> getLocationOffset(int line, int column) {
        return CelSource.getLocationOffsetImpl(this.lineOffsets, line, column);
    }

    public Optional<CelSourceLocation> getOffsetLocation(int offset) {
        return CelSource.getOffsetLocationImpl(this.lineOffsets, offset);
    }

    public Optional<String> getSnippet(int line) {
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        int start = CelSource.findLineOffset(this.lineOffsets, line);
        if (start == -1) {
            return Optional.empty();
        }
        int end = CelSource.findLineOffset(this.lineOffsets, line + 1);
        end = end == -1 ? this.codePoints.size() : --end;
        return Optional.of(end != start ? this.codePoints.slice(start, end).toString() : "");
    }

    private static Optional<Integer> getLocationOffsetImpl(List<Integer> lineOffsets, int line, int column) {
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0);
        int offset = CelSource.findLineOffset(lineOffsets, line);
        if (offset == -1) {
            return Optional.empty();
        }
        return Optional.of(offset + column);
    }

    public static Optional<CelSourceLocation> getOffsetLocationImpl(List<Integer> lineOffsets, int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        LineAndOffset lineAndOffset = CelSource.findLine(lineOffsets, offset);
        return Optional.of(CelSourceLocation.of(lineAndOffset.line, offset - lineAndOffset.offset));
    }

    private static int findLineOffset(List<Integer> lineOffsets, int line) {
        if (line == 1) {
            return 0;
        }
        if (line > 1 && line <= lineOffsets.size()) {
            return lineOffsets.get(line - 2);
        }
        return -1;
    }

    private static LineAndOffset findLine(List<Integer> lineOffsets, int offset) {
        int line = 1;
        for (int index = 0; index < lineOffsets.size() && lineOffsets.get(index) <= offset; ++index) {
            ++line;
        }
        if (line == 1) {
            return new LineAndOffset(line, 0);
        }
        return new LineAndOffset(line, lineOffsets.get(line - 2));
    }

    public Builder toBuilder() {
        return new Builder(this.codePoints, (List)this.lineOffsets).setDescription(this.description).addPositionsMap((Map<Long, Integer>)this.positions).addAllMacroCalls((Map<Long, CelExpr>)this.macroCalls);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String text) {
        ArrayList<Integer> lineOffsets = new ArrayList<Integer>();
        int lineOffset = 0;
        for (String line : LINE_SPLITTER.split((CharSequence)text)) {
            lineOffsets.add(lineOffset += (int)(line.codePoints().count() + 1L));
        }
        return new Builder(CelCodePointArray.fromString(text), lineOffsets);
    }

    public static final class Builder {
        private final CelCodePointArray codePoints;
        private final List<Integer> lineOffsets;
        private final ImmutableMap.Builder<Long, Integer> positions;
        private final Map<Long, CelExpr> macroCalls;
        private String description;

        private Builder() {
            this(CelCodePointArray.fromString(""), new ArrayList<Integer>());
        }

        private Builder(CelCodePointArray codePoints, List<Integer> lineOffsets) {
            this.codePoints = (CelCodePointArray)Preconditions.checkNotNull((Object)codePoints);
            this.lineOffsets = (List)Preconditions.checkNotNull(lineOffsets);
            this.positions = ImmutableMap.builder();
            this.macroCalls = new HashMap<Long, CelExpr>();
            this.description = "";
        }

        @CanIgnoreReturnValue
        public Builder setDescription(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLineOffsets(int lineOffset) {
            Preconditions.checkArgument((lineOffset >= 0 ? 1 : 0) != 0);
            this.lineOffsets.add(lineOffset);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addLineOffsets(int ... lineOffsets) {
            for (int index = 0; index != lineOffsets.length; ++index) {
                this.addLineOffsets(lineOffsets[index]);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllLineOffsets(Iterable<Integer> lineOffsets) {
            for (int lineOffset : lineOffsets) {
                this.addLineOffsets(lineOffset);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPositionsMap(Map<Long, Integer> positionsMap) {
            Preconditions.checkNotNull(positionsMap);
            this.positions.putAll(positionsMap);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPositions(long exprId, int position) {
            this.positions.put((Object)exprId, (Object)position);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addMacroCalls(long exprId, CelExpr expr) {
            this.macroCalls.put(exprId, expr);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllMacroCalls(Map<Long, CelExpr> macroCalls) {
            this.macroCalls.putAll(macroCalls);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clearMacroCall(long exprId) {
            this.macroCalls.remove(exprId);
            return this;
        }

        public Optional<Integer> getLocationOffset(CelSourceLocation location) {
            Preconditions.checkNotNull((Object)location);
            return this.getLocationOffset(location.getLine(), location.getColumn());
        }

        public Optional<Integer> getLocationOffset(int line, int column) {
            return CelSource.getLocationOffsetImpl(this.lineOffsets, line, column);
        }

        public Optional<CelSourceLocation> getOffsetLocation(int offset) {
            return CelSource.getOffsetLocationImpl(this.lineOffsets, offset);
        }

        @CheckReturnValue
        public ImmutableMap<Long, Integer> getPositionsMap() {
            return this.positions.buildOrThrow();
        }

        @CheckReturnValue
        public Map<Long, CelExpr> getMacroCalls() {
            return this.macroCalls;
        }

        @CheckReturnValue
        public boolean containsMacroCalls(long exprId) {
            return this.macroCalls.containsKey(exprId);
        }

        @CheckReturnValue
        public CelSource build() {
            return new CelSource(this);
        }
    }

    private static final class LineAndOffset {
        int line;
        int offset;

        private LineAndOffset(int line, int offset) {
            this.line = line;
            this.offset = offset;
        }
    }
}

