/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;

final class CelExprFormatter {
    private final StringBuilder indent = new StringBuilder();
    private final StringBuilder exprBuilder = new StringBuilder();

    static String format(CelExpr celExpr) {
        CelExprFormatter formatter = new CelExprFormatter();
        formatter.formatExpr(celExpr);
        return formatter.exprBuilder.toString();
    }

    private void formatExpr(CelExpr celExpr) {
        this.append(String.format("%s [%d] {", new Object[]{celExpr.exprKind().getKind(), celExpr.id()}));
        CelExpr.ExprKind.Kind exprKind = celExpr.exprKind().getKind();
        if (!exprKind.equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
            this.appendNewline();
        }
        switch (exprKind) {
            case CONSTANT: {
                this.appendConst(celExpr.constant());
                break;
            }
            case IDENT: {
                this.appendIdent(celExpr.ident());
                break;
            }
            case SELECT: {
                this.appendSelect(celExpr.select());
                break;
            }
            case CALL: {
                this.appendCall(celExpr.call());
                break;
            }
            case CREATE_LIST: {
                this.appendCreateList(celExpr.createList());
                break;
            }
            case CREATE_STRUCT: {
                this.appendCreateStruct(celExpr.createStruct());
                break;
            }
            case CREATE_MAP: {
                this.appendCreateMap(celExpr.createMap());
                break;
            }
            case COMPREHENSION: {
                this.appendComprehension(celExpr.comprehension());
                break;
            }
            default: {
                this.append("Unknown kind: " + (Object)((Object)exprKind));
            }
        }
        if (!exprKind.equals((Object)CelExpr.ExprKind.Kind.CONSTANT)) {
            this.appendNewline();
            this.append("}");
        } else {
            this.appendWithoutIndent("}");
        }
    }

    private void appendConst(CelConstant celConstant) {
        this.appendWithoutIndent(" value: ");
        switch (celConstant.getKind()) {
            case NULL_VALUE: {
                this.appendWithoutIndent("null");
                break;
            }
            case BOOLEAN_VALUE: {
                this.appendWithoutIndent(Boolean.toString(celConstant.booleanValue()));
                break;
            }
            case INT64_VALUE: {
                this.appendWithoutIndent(Long.toString(celConstant.int64Value()));
                break;
            }
            case UINT64_VALUE: {
                this.appendWithoutIndent(celConstant.uint64Value() + "u");
                break;
            }
            case DOUBLE_VALUE: {
                this.appendWithoutIndent(Double.toString(celConstant.doubleValue()));
                break;
            }
            case STRING_VALUE: {
                this.appendWithoutIndent("\"" + celConstant.stringValue() + "\"");
                break;
            }
            case BYTES_VALUE: {
                this.appendWithoutIndent(String.format("b\"%s\"", celConstant.bytesValue().toStringUtf8()));
                break;
            }
            default: {
                this.append("Unknown kind: " + (Object)((Object)celConstant.getKind()));
            }
        }
        this.appendWithoutIndent(" ");
    }

    private void appendIdent(CelExpr.CelIdent celIdent) {
        this.indent();
        this.append("name: " + celIdent.name());
        this.outdent();
    }

    private void appendSelect(CelExpr.CelSelect celSelect) {
        this.indent();
        this.formatExpr(celSelect.operand());
        this.outdent();
        this.append(".");
        this.append(celSelect.field());
        if (celSelect.testOnly()) {
            this.appendWithoutIndent("~presence_test");
        }
    }

    private void appendCall(CelExpr.CelCall celCall) {
        this.indent();
        this.appendWithNewline("function: " + celCall.function());
        if (celCall.target().isPresent()) {
            this.appendWithNewline("target: {");
            this.indent();
            this.formatExpr(celCall.target().get());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
        }
        this.append("args: {");
        this.indent();
        for (CelExpr celExpr : celCall.args()) {
            this.appendNewline();
            this.formatExpr(celExpr);
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void appendCreateList(CelExpr.CelCreateList celCreateList) {
        this.indent();
        this.append("elements: {");
        this.indent();
        for (CelExpr expr : celCreateList.elements()) {
            this.appendNewline();
            this.formatExpr(expr);
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        if (!celCreateList.optionalIndices().isEmpty()) {
            this.appendNewline();
            this.append("optional_indices: [");
            for (int i = 0; i < celCreateList.optionalIndices().size(); ++i) {
                this.appendWithoutIndent(String.valueOf(i));
                if (i == celCreateList.optionalIndices().size() - 1) continue;
                this.appendWithoutIndent(", ");
            }
            this.appendWithoutIndent("]");
        }
        this.outdent();
    }

    private void appendCreateStruct(CelExpr.CelCreateStruct celCreateStruct) {
        this.indent();
        this.appendWithNewline("name: " + celCreateStruct.messageName());
        this.append("entries: {");
        this.indent();
        for (CelExpr.CelCreateStruct.Entry entry : celCreateStruct.entries()) {
            this.appendNewline();
            this.appendWithNewline(String.format("ENTRY [%d] {", entry.id()));
            this.indent();
            this.appendWithNewline("field_key: " + entry.fieldKey());
            if (entry.optionalEntry()) {
                this.appendWithNewline("optional_entry: true");
            }
            this.appendWithNewline("value: {");
            this.indent();
            this.formatExpr(entry.value());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            this.outdent();
            this.append("}");
        }
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void appendCreateMap(CelExpr.CelCreateMap celCreateMap) {
        this.indent();
        boolean firstLine = true;
        for (CelExpr.CelCreateMap.Entry entry : celCreateMap.entries()) {
            if (!firstLine) {
                this.appendNewline();
            } else {
                firstLine = false;
            }
            this.appendWithNewline(String.format("MAP_ENTRY [%d] {", entry.id()));
            this.indent();
            this.appendWithNewline("key: {");
            this.indent();
            this.formatExpr(entry.key());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            if (entry.optionalEntry()) {
                this.appendWithNewline("optional_entry: true");
            }
            this.appendWithNewline("value: {");
            this.indent();
            this.formatExpr(entry.value());
            this.outdent();
            this.appendNewline();
            this.appendWithNewline("}");
            this.outdent();
            this.append("}");
        }
        this.outdent();
    }

    private void appendComprehension(CelExpr.CelComprehension celComprehension) {
        this.indent();
        this.appendWithNewline("iter_var: " + celComprehension.iterVar());
        this.appendWithNewline("iter_range: {");
        this.indent();
        this.formatExpr(celComprehension.iterRange());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("accu_var: " + celComprehension.accuVar());
        this.appendWithNewline("accu_init: {");
        this.indent();
        this.formatExpr(celComprehension.accuInit());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("loop_condition: {");
        this.indent();
        this.formatExpr(celComprehension.loopCondition());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("loop_step: {");
        this.indent();
        this.formatExpr(celComprehension.loopStep());
        this.outdent();
        this.appendNewline();
        this.appendWithNewline("}");
        this.appendWithNewline("result: {");
        this.indent();
        this.formatExpr(celComprehension.result());
        this.outdent();
        this.appendNewline();
        this.append("}");
        this.outdent();
    }

    private void append(String str) {
        this.exprBuilder.append((CharSequence)this.indent);
        this.exprBuilder.append(str);
    }

    private void appendWithNewline(String str) {
        this.append(str);
        this.appendNewline();
    }

    private void appendWithoutIndent(String str) {
        this.exprBuilder.append(str);
    }

    private void appendNewline() {
        this.exprBuilder.append('\n');
    }

    private void indent() {
        this.indent.append("  ");
    }

    private void outdent() {
        this.indent.setLength(this.indent.length() - 2);
    }

    private CelExprFormatter() {
    }
}

