/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import java.text.ParseException;
import java.util.PrimitiveIterator;

@Internal
public final class Constants {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String TRIPLE_DOUBLE_QUOTE = "\"\"\"";
    private static final String TRIPLE_SINGLE_QUOTE = "'''";
    private static final int MAX_SCRATCH_CODE_POINTS = 8;
    private static final int MIN_CODE_POINT = 0;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private static final int MIN_SURROGATE = 55296;
    private static final int MAX_SURROGATE = 57343;
    public static final CelConstant NULL = CelConstant.ofValue(NullValue.NULL_VALUE);
    public static final CelConstant FALSE = CelConstant.ofValue(false);
    public static final CelConstant TRUE = CelConstant.ofValue(true);
    public static final CelConstant ERROR = CelConstant.ofValue("<<error>>");

    public static CelConstant parseInt(String text) throws ParseException {
        long value;
        int base;
        if (text.startsWith("-0x")) {
            base = 16;
            text = text.substring(3);
            text = "-" + text;
        } else if (text.startsWith("0x")) {
            base = 16;
            if ((text = text.substring(2)).startsWith("-")) {
                throw new ParseException("Integer literal is malformed", 0);
            }
        } else {
            base = 10;
        }
        try {
            value = Long.parseLong(text, base);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return CelConstant.ofValue(value);
    }

    public static CelConstant parseUint(String text) throws ParseException {
        long value;
        int base;
        if (!text.endsWith("u") && !text.endsWith("U")) {
            throw new ParseException("Unsigned integer literal is missing trailing 'u' suffix", 0);
        }
        if ((text = text.substring(0, text.length() - 1)).startsWith("0x")) {
            base = 16;
            text = text.substring(2);
        } else {
            base = 10;
        }
        try {
            value = Long.parseUnsignedLong(text, base);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return CelConstant.ofValue(UnsignedLong.fromLongBits((long)value));
    }

    public static CelConstant parseDouble(String text) throws ParseException {
        double value;
        try {
            value = Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return CelConstant.ofValue(value);
    }

    public static CelConstant parseBytes(String text) throws ParseException {
        String quote;
        boolean isRawLiteral = false;
        int offset = 0;
        if (text.startsWith("r") || text.startsWith("R")) {
            isRawLiteral = true;
            text = text.substring(1);
            ++offset;
            if (!text.startsWith("b") && !text.startsWith("B")) {
                throw new ParseException("Bytes literal is missing leading 'b' or 'B' prefix", 0);
            }
            text = text.substring(1);
            ++offset;
        } else {
            if (!text.startsWith("b") && !text.startsWith("B")) {
                throw new ParseException("Bytes literal is missing leading 'b' or 'B' prefix", 0);
            }
            text = text.substring(1);
            ++offset;
            if (text.startsWith("r") || text.startsWith("R")) {
                isRawLiteral = true;
                text = text.substring(1);
                ++offset;
            }
        }
        if (text.startsWith(TRIPLE_DOUBLE_QUOTE)) {
            quote = TRIPLE_DOUBLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(TRIPLE_SINGLE_QUOTE)) {
            quote = TRIPLE_SINGLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(DOUBLE_QUOTE)) {
            quote = DOUBLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(SINGLE_QUOTE)) {
            quote = SINGLE_QUOTE;
            text = text.substring(quote.length());
        } else {
            throw new ParseException("Bytes literal is missing surrounding single or double quotes", 0);
        }
        Constants.checkForClosingQuote(text, quote);
        Preconditions.checkState((boolean)text.endsWith(quote));
        text = text.substring(0, text.length() - quote.length());
        DecodeByteStringBuffer buffer = new DecodeByteStringBuffer(text.length());
        Constants.decodeString(offset += quote.length(), text, buffer, isRawLiteral, true);
        return CelConstant.ofValue((ByteString)buffer.toDecodedValue());
    }

    public static CelConstant parseString(String text) throws ParseException {
        String quote;
        int offset = 0;
        boolean isRawLiteral = false;
        if (text.startsWith("r") || text.startsWith("R")) {
            isRawLiteral = true;
            text = text.substring(1);
            ++offset;
        }
        if (text.startsWith(TRIPLE_DOUBLE_QUOTE)) {
            quote = TRIPLE_DOUBLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(TRIPLE_SINGLE_QUOTE)) {
            quote = TRIPLE_SINGLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(DOUBLE_QUOTE)) {
            quote = DOUBLE_QUOTE;
            text = text.substring(quote.length());
        } else if (text.startsWith(SINGLE_QUOTE)) {
            quote = SINGLE_QUOTE;
            text = text.substring(quote.length());
        } else {
            throw new ParseException("String literal is missing surrounding single or double quotes", 0);
        }
        Constants.checkForClosingQuote(text, quote);
        Preconditions.checkState((boolean)text.endsWith(quote));
        text = text.substring(0, text.length() - quote.length());
        DecodeStringBuffer buffer = new DecodeStringBuffer(text.length());
        Constants.decodeString(offset += quote.length(), text, buffer, isRawLiteral, false);
        return CelConstant.ofValue((String)buffer.toDecodedValue());
    }

    private static <T> void decodeString(int offset, String text, DecodeBuffer<T> buffer, boolean isRawLiteral, boolean isBytesLiteral) throws ParseException {
        boolean skipNewline = false;
        PrimitiveIterator.OfInt iterator = text.codePoints().iterator();
        int[] scratchCodePoints = null;
        block18: while (iterator.hasNext()) {
            int seqOffset = offset++;
            int codePoint = iterator.nextInt();
            if (codePoint != 92) {
                if (codePoint != 13) {
                    if (codePoint == 10 && skipNewline) {
                        skipNewline = false;
                        continue;
                    }
                    skipNewline = false;
                    buffer.appendCodePoint(codePoint);
                    continue;
                }
                buffer.appendCodePoint(10);
                skipNewline = true;
                continue;
            }
            skipNewline = false;
            if (!iterator.hasNext()) {
                throw new ParseException(isRawLiteral ? "Raw literals cannot end with an odd number of \\" : (isBytesLiteral ? "Bytes literal cannot end with \\" : "String literal cannot end with \\"), seqOffset);
            }
            codePoint = iterator.nextInt();
            ++offset;
            if (isRawLiteral) {
                buffer.appendCodePoint(92);
                buffer.appendCodePoint(codePoint);
                continue;
            }
            switch (codePoint) {
                case 97: {
                    buffer.appendByte((byte)7);
                    continue block18;
                }
                case 98: {
                    buffer.appendByte((byte)8);
                    continue block18;
                }
                case 102: {
                    buffer.appendByte((byte)12);
                    continue block18;
                }
                case 110: {
                    buffer.appendByte((byte)10);
                    continue block18;
                }
                case 114: {
                    buffer.appendByte((byte)13);
                    continue block18;
                }
                case 116: {
                    buffer.appendByte((byte)9);
                    continue block18;
                }
                case 118: {
                    buffer.appendByte((byte)11);
                    continue block18;
                }
                case 34: {
                    buffer.appendByte((byte)34);
                    continue block18;
                }
                case 39: {
                    buffer.appendByte((byte)39);
                    continue block18;
                }
                case 92: {
                    buffer.appendByte((byte)92);
                    continue block18;
                }
                case 63: {
                    buffer.appendByte((byte)63);
                    continue block18;
                }
                case 96: {
                    buffer.appendByte((byte)96);
                    continue block18;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    if (scratchCodePoints == null) {
                        scratchCodePoints = new int[8];
                    }
                    if (!Constants.nextInts(iterator, 2, scratchCodePoints) || !Constants.areOctalDigits(scratchCodePoints, 2)) {
                        throw new ParseException("Invalid octal escape sequence", seqOffset);
                    }
                    int octalValue = codePoint - 48;
                    octalValue = octalValue * 8 + (scratchCodePoints[0] - 48);
                    octalValue = octalValue * 8 + (scratchCodePoints[1] - 48);
                    buffer.appendByte((byte)octalValue);
                    offset += 2;
                    continue block18;
                }
                case 88: 
                case 120: {
                    if (scratchCodePoints == null) {
                        scratchCodePoints = new int[8];
                    }
                    if (!Constants.nextInts(iterator, 2, scratchCodePoints) || !Constants.areHexDigits(scratchCodePoints, 2)) {
                        throw new ParseException("Invalid hex escape sequence", seqOffset);
                    }
                    int value = Constants.unhex(scratchCodePoints, 2);
                    buffer.appendByte((byte)value);
                    offset += 2;
                    continue block18;
                }
                case 117: {
                    if (isBytesLiteral) {
                        throw new ParseException("Illegal escape sequence: Unicode escape sequences cannot be used in bytes literal", seqOffset);
                    }
                    if (scratchCodePoints == null) {
                        scratchCodePoints = new int[8];
                    }
                    if (!Constants.nextInts(iterator, 4, scratchCodePoints) || !Constants.areHexDigits(scratchCodePoints, 4)) {
                        throw new ParseException("Invalid unicode escape sequence", seqOffset);
                    }
                    int value = Constants.unhex(scratchCodePoints, 4);
                    if (value < 0 || value > 0x10FFFF || value >= 55296 && value <= 57343) {
                        throw new ParseException("Invalid unicode code point", seqOffset);
                    }
                    buffer.appendCodePoint(value);
                    offset += 4;
                    continue block18;
                }
                case 85: {
                    if (isBytesLiteral) {
                        throw new ParseException("Illegal escape sequence: Unicode escape sequences cannot be used in bytes literal", offset);
                    }
                    if (scratchCodePoints == null) {
                        scratchCodePoints = new int[8];
                    }
                    if (!Constants.nextInts(iterator, 8, scratchCodePoints) || !Constants.areHexDigits(scratchCodePoints, 8)) {
                        throw new ParseException("Invalid unicode escape sequence", seqOffset);
                    }
                    int value = Constants.unhex(scratchCodePoints, 8);
                    if (value < 0 || value > 0x10FFFF || value >= 55296 && value <= 57343) {
                        throw new ParseException("Invalid unicode code point", seqOffset);
                    }
                    buffer.appendCodePoint(value);
                    offset += 8;
                    continue block18;
                }
            }
            throw new ParseException("Illegal escape sequence", seqOffset);
        }
    }

    private static boolean nextInts(PrimitiveIterator.OfInt iterator, int count, int[] scratch) {
        Preconditions.checkArgument((count <= scratch.length ? 1 : 0) != 0);
        int index = 0;
        while (iterator.hasNext() && index < count) {
            scratch[index++] = iterator.nextInt();
        }
        return index == count;
    }

    private static boolean isOctalDigit(int codePoint) {
        return codePoint >= 48 && codePoint <= 55;
    }

    private static boolean isHexDigit(int codePoint) {
        return codePoint >= 97 && codePoint <= 102 || codePoint >= 65 && codePoint <= 70 || codePoint >= 48 && codePoint <= 57;
    }

    private static boolean isDigit(int codePoint) {
        return codePoint >= 48 && codePoint <= 57;
    }

    private static int toLowerCase(int codePoint) {
        return codePoint >= 65 && codePoint <= 90 ? codePoint - 65 + 97 : codePoint;
    }

    private static boolean areOctalDigits(int[] codePoints, int count) {
        Preconditions.checkArgument((count <= codePoints.length ? 1 : 0) != 0);
        for (int index = 0; index < count; ++index) {
            if (Constants.isOctalDigit(codePoints[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean areHexDigits(int[] codePoints, int count) {
        Preconditions.checkArgument((count <= codePoints.length ? 1 : 0) != 0);
        for (int index = 0; index < count; ++index) {
            if (Constants.isHexDigit(codePoints[index])) continue;
            return false;
        }
        return true;
    }

    private static void checkForClosingQuote(String text, String quote) throws ParseException {
        if (quote.isEmpty()) {
            return;
        }
        if (text.length() < quote.length()) {
            throw new ParseException(String.format("String literal missing terminating quote %s", quote), 0);
        }
        int position = 0;
        boolean isClosed = false;
        while (position + quote.length() <= text.length()) {
            char codeUnit = text.charAt(position);
            if (codeUnit != '\\') {
                if (text.substring(position).startsWith(quote)) {
                    isClosed = position + quote.length() == text.length();
                    break;
                }
            } else {
                ++position;
            }
            ++position;
        }
        if (!isClosed) {
            throw new ParseException(String.format("String literal contains unescaped terminating quote %s", quote), 0);
        }
    }

    private static int unhex(int value, int nextValue) {
        if (Constants.isDigit(nextValue)) {
            return value * 16 + (nextValue - 48);
        }
        return value * 16 + (Constants.toLowerCase(nextValue) - 97 + 10);
    }

    private static int unhex(int[] codePoints, int length) {
        int value = 0;
        for (int index = 0; index < length; ++index) {
            value = Constants.unhex(value, codePoints[index]);
        }
        return value;
    }

    private Constants() {
    }

    private static final class DecodeByteStringBuffer
    implements DecodeBuffer<ByteString> {
        private final ByteString.Output output;

        private DecodeByteStringBuffer(int initialCapacity) {
            this.output = ByteString.newOutput((int)initialCapacity);
        }

        @Override
        public void appendByte(byte b) {
            this.output.write((int)b);
        }

        @Override
        public void appendCodePoint(int codePoint) {
            Preconditions.checkArgument((codePoint >= 0 && codePoint <= 0x10FFFF ? 1 : 0) != 0);
            if (codePoint < 128) {
                this.output.write((int)((byte)codePoint));
            } else if (codePoint < 2048) {
                this.output.write((int)((byte)(0x3C0 | codePoint >>> 6)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint)));
            } else if (codePoint < 65536) {
                this.output.write((int)((byte)(0x1E0 | codePoint >>> 12)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint >>> 6)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint)));
            } else {
                this.output.write((int)((byte)(0xF0 | codePoint >>> 18)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint >>> 12)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint >>> 6)));
                this.output.write((int)((byte)(0x80 | 0x3F & codePoint)));
            }
        }

        @Override
        public ByteString toDecodedValue() {
            return this.output.toByteString();
        }
    }

    private static interface DecodeBuffer<T> {
        public void appendByte(byte var1);

        public void appendCodePoint(int var1);

        public T toDecodedValue();
    }

    private static final class DecodeStringBuffer
    implements DecodeBuffer<String> {
        private final StringBuilder builder;

        private DecodeStringBuffer(int initialCapacity) {
            this.builder = new StringBuilder(initialCapacity);
        }

        @Override
        public void appendByte(byte b) {
            this.builder.appendCodePoint(b & 0xFF);
        }

        @Override
        public void appendCodePoint(int codePoint) {
            Preconditions.checkArgument((codePoint >= 0 && codePoint <= 0x10FFFF ? 1 : 0) != 0);
            this.builder.appendCodePoint(codePoint);
        }

        @Override
        public String toDecodedValue() {
            return this.builder.toString();
        }
    }
}

