/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import dev.cel.common.CelDescriptors;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.WellKnownProto;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;

@Immutable
@Internal
public final class DefaultDescriptorPool
implements CelDescriptorPool {
    private static final ImmutableMap<String, Descriptors.Descriptor> WELL_KNOWN_TYPE_DESCRIPTORS = (ImmutableMap)Arrays.stream(WellKnownProto.values()).collect(ImmutableMap.toImmutableMap(WellKnownProto::typeName, WellKnownProto::descriptor));
    public static final DefaultDescriptorPool INSTANCE = new DefaultDescriptorPool(WELL_KNOWN_TYPE_DESCRIPTORS, (ImmutableMultimap<String, Descriptors.FieldDescriptor>)ImmutableMultimap.of(), ExtensionRegistry.getEmptyRegistry());
    private final ImmutableMap<String, Descriptors.Descriptor> descriptorMap;
    private final ImmutableMultimap<String, Descriptors.FieldDescriptor> extensionDescriptorMap;
    private final ExtensionRegistry extensionRegistry;

    public static DefaultDescriptorPool create(CelDescriptors celDescriptors) {
        return DefaultDescriptorPool.create(celDescriptors, ExtensionRegistry.getEmptyRegistry());
    }

    public static DefaultDescriptorPool create(CelDescriptors celDescriptors, ExtensionRegistry extensionRegistry) {
        HashMap<String, Descriptors.Descriptor> descriptorMap = new HashMap<String, Descriptors.Descriptor>();
        Arrays.stream(WellKnownProto.values()).forEach(d -> descriptorMap.put(d.typeName(), d.descriptor()));
        for (Descriptors.Descriptor descriptor : celDescriptors.messageTypeDescriptors()) {
            descriptorMap.putIfAbsent(descriptor.getFullName(), descriptor);
        }
        return new DefaultDescriptorPool((ImmutableMap<String, Descriptors.Descriptor>)ImmutableMap.copyOf(descriptorMap), celDescriptors.extensionDescriptors(), extensionRegistry);
    }

    @Override
    public Optional<Descriptors.Descriptor> findDescriptor(String name) {
        return Optional.ofNullable((Descriptors.Descriptor)this.descriptorMap.get((Object)name));
    }

    @Override
    public Optional<Descriptors.FieldDescriptor> findExtensionDescriptor(Descriptors.Descriptor containingDescriptor, String fieldName) {
        String typeName = containingDescriptor.getFullName();
        ImmutableCollection fieldDescriptors = this.extensionDescriptorMap.get((Object)typeName);
        return fieldDescriptors.stream().filter(d -> d.getFullName().equals(fieldName)).findFirst();
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    private DefaultDescriptorPool(ImmutableMap<String, Descriptors.Descriptor> descriptorMap, ImmutableMultimap<String, Descriptors.FieldDescriptor> extensionDescriptorMap, ExtensionRegistry extensionRegistry) {
        this.descriptorMap = (ImmutableMap)Preconditions.checkNotNull(descriptorMap);
        this.extensionDescriptorMap = (ImmutableMultimap)Preconditions.checkNotNull(extensionDescriptorMap);
        this.extensionRegistry = (ExtensionRegistry)Preconditions.checkNotNull((Object)extensionRegistry);
    }
}

