/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.annotations.Internal;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class DefaultInstanceMessageFactory {
    public static final int SAFE_RECURSE_LIMIT = 50;
    private static final DefaultInstanceMessageFactory instance = new DefaultInstanceMessageFactory();
    private final Map<String, LazyGeneratedMessageDefaultInstance> messageByDescriptorName = new ConcurrentHashMap<String, LazyGeneratedMessageDefaultInstance>();

    public static DefaultInstanceMessageFactory getInstance() {
        return instance;
    }

    public Optional<Message> getPrototype(Descriptors.Descriptor descriptor) {
        String descriptorName = descriptor.getFullName();
        LazyGeneratedMessageDefaultInstance lazyDefaultInstance = this.messageByDescriptorName.computeIfAbsent(descriptorName, unused -> new LazyGeneratedMessageDefaultInstance(this.getFullyQualifiedJavaClassName(descriptor)));
        Message defaultInstance = lazyDefaultInstance.getDefaultInstance();
        if (defaultInstance == null) {
            return Optional.empty();
        }
        if (defaultInstance.getDescriptorForType() != descriptor) {
            return Optional.empty();
        }
        return Optional.of(defaultInstance);
    }

    private String getFullyQualifiedJavaClassName(Descriptors.Descriptor descriptor) {
        StringBuilder fullClassName = new StringBuilder();
        fullClassName.append(this.getJavaPackageName(descriptor));
        String javaOuterClass = this.getJavaOuterClassName(descriptor);
        if (!Strings.isNullOrEmpty((String)javaOuterClass)) {
            fullClassName.append(javaOuterClass).append("$");
        }
        ArrayDeque<String> classNames = new ArrayDeque<String>();
        int recurseCount = 0;
        for (Descriptors.Descriptor d = descriptor; d != null; d = d.getContainingType()) {
            classNames.push(d.getName());
            if (++recurseCount < 50) continue;
            throw new IllegalStateException(String.format("Recursion limit of %d hit while inspecting descriptor: %s", 50, descriptor.getFullName()));
        }
        Joiner.on((String)"$").appendTo(fullClassName, classNames);
        return fullClassName.toString();
    }

    private String getJavaPackageName(Descriptors.Descriptor descriptor) {
        DescriptorProtos.FileOptions options = descriptor.getFile().getOptions();
        StringBuilder javaPackageName = new StringBuilder();
        if (options.hasJavaPackage()) {
            javaPackageName.append(descriptor.getFile().getOptions().getJavaPackage()).append(".");
        } else {
            javaPackageName.append(descriptor.getFile().getPackage()).append(".");
        }
        return javaPackageName.toString();
    }

    private String getJavaOuterClassName(Descriptors.Descriptor descriptor) {
        DescriptorProtos.FileOptions options = descriptor.getFile().getOptions();
        if (options.getJavaMultipleFiles()) {
            return "";
        }
        if (options.hasJavaOuterClassname()) {
            return options.getJavaOuterClassname();
        }
        String protoFileNameWithoutExtension = Files.getNameWithoutExtension((String)descriptor.getFile().getFullName());
        String outerClassName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, protoFileNameWithoutExtension);
        if (this.hasConflictingClassName(descriptor.getFile(), outerClassName)) {
            outerClassName = outerClassName + "OuterClass";
        }
        return outerClassName;
    }

    private boolean hasConflictingClassName(Descriptors.FileDescriptor file, String name) {
        for (Descriptors.EnumDescriptor enumDesc : file.getEnumTypes()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (Descriptors.ServiceDescriptor serviceDesc : file.getServices()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (Descriptors.Descriptor messageDesc : file.getMessageTypes()) {
            if (!name.equals(messageDesc.getName())) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetDescriptorMapForTesting() {
        this.messageByDescriptorName.clear();
    }

    private DefaultInstanceMessageFactory() {
    }

    private static final class LazyGeneratedMessageDefaultInstance {
        private final String fullClassName;
        private volatile Message defaultInstance = null;
        private volatile boolean loaded = false;

        public LazyGeneratedMessageDefaultInstance(String fullClassName) {
            this.fullClassName = fullClassName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getDefaultInstance() {
            if (!this.loaded) {
                LazyGeneratedMessageDefaultInstance lazyGeneratedMessageDefaultInstance = this;
                synchronized (lazyGeneratedMessageDefaultInstance) {
                    if (!this.loaded) {
                        this.loadDefaultInstance();
                        this.loaded = true;
                    }
                }
            }
            return this.defaultInstance;
        }

        private void loadDefaultInstance() {
            try {
                this.defaultInstance = (Message)Class.forName(this.fullClassName).getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new LinkageError(String.format("getDefaultInstance for class: %s failed.", this.fullClassName), e);
            }
            catch (NoSuchMethodException e) {
                throw new LinkageError(String.format("getDefaultInstance method does not exist in class: %s.", this.fullClassName), e);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

