/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.google.protobuf.WireFormat;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AdaptingTypes;
import dev.cel.common.internal.BidiConverter;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.WellKnownProto;
import dev.cel.expr.ExprValue;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@Immutable
@CheckReturnValue
@Internal
public final class ProtoAdapter {
    public static final BidiConverter<Number, Number> INT_CONVERTER = BidiConverter.of(Number::longValue, value -> ProtoAdapter.intCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> SIGNED_UINT32_CONVERTER = BidiConverter.of(value -> UnsignedInts.toLong((int)value.intValue()), value -> ProtoAdapter.unsignedIntCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> UNSIGNED_UINT32_CONVERTER = BidiConverter.of(value -> UnsignedLong.fromLongBits((long)Integer.toUnsignedLong(value.intValue())), value -> ProtoAdapter.unsignedIntCheckedCast(value.longValue()));
    public static final BidiConverter<Number, Number> UNSIGNED_UINT64_CONVERTER = BidiConverter.of(value -> UnsignedLong.fromLongBits((long)value.longValue()), Number::longValue);
    public static final BidiConverter<Number, Number> DOUBLE_CONVERTER = BidiConverter.of(Number::doubleValue, Number::floatValue);
    private final DynamicProto dynamicProto;
    private final boolean enableUnsignedLongs;
    private static final long JSON_MAX_INT_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long JSON_MIN_INT_VALUE = -9007199254740991L;
    private static final UnsignedLong JSON_MAX_UINT_VALUE = UnsignedLong.fromLongBits((long)0x1FFFFFFFFFFFFFL);

    public ProtoAdapter(DynamicProto dynamicProto, boolean enableUnsignedLongs) {
        this.dynamicProto = (DynamicProto)Preconditions.checkNotNull((Object)dynamicProto);
        this.enableUnsignedLongs = enableUnsignedLongs;
    }

    public Object adaptProtoToValue(MessageOrBuilder proto) {
        WellKnownProto wellKnownProto;
        if (proto instanceof DynamicMessage) {
            proto = this.dynamicProto.maybeAdaptDynamicMessage((DynamicMessage)proto);
        }
        if ((wellKnownProto = WellKnownProto.getByDescriptorName(ProtoAdapter.typeName(proto.getDescriptorForType()))) == null) {
            return proto;
        }
        switch (wellKnownProto) {
            case ANY_VALUE: {
                return this.unpackAnyProto((Any)proto);
            }
            case JSON_VALUE: {
                return this.adaptJsonToValue((Value)proto);
            }
            case JSON_STRUCT_VALUE: {
                return this.adaptJsonStructToValue((Struct)proto);
            }
            case JSON_LIST_VALUE: {
                return this.adaptJsonListToValue((ListValue)proto);
            }
            case BOOL_VALUE: {
                return ((BoolValue)proto).getValue();
            }
            case BYTES_VALUE: {
                return ((BytesValue)proto).getValue();
            }
            case DOUBLE_VALUE: {
                return ((DoubleValue)proto).getValue();
            }
            case FLOAT_VALUE: {
                return (double)((FloatValue)proto).getValue();
            }
            case INT32_VALUE: {
                return (long)((Int32Value)proto).getValue();
            }
            case INT64_VALUE: {
                return ((Int64Value)proto).getValue();
            }
            case STRING_VALUE: {
                return ((StringValue)proto).getValue();
            }
            case UINT32_VALUE: {
                if (this.enableUnsignedLongs) {
                    return UnsignedLong.fromLongBits((long)Integer.toUnsignedLong(((UInt32Value)proto).getValue()));
                }
                return (long)((UInt32Value)proto).getValue();
            }
            case UINT64_VALUE: {
                if (this.enableUnsignedLongs) {
                    return UnsignedLong.fromLongBits((long)((UInt64Value)proto).getValue());
                }
                return ((UInt64Value)proto).getValue();
            }
        }
        return proto;
    }

    public Optional<Object> adaptFieldToValue(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (ProtoAdapter.isUnknown(fieldValue)) {
            return Optional.of(fieldValue);
        }
        if (fieldDescriptor.isMapField()) {
            Descriptors.Descriptor entryDescriptor = fieldDescriptor.getMessageType();
            BidiConverter keyConverter = this.fieldToValueConverter(entryDescriptor.findFieldByNumber(1));
            BidiConverter valueConverter = this.fieldToValueConverter(entryDescriptor.findFieldByNumber(2));
            HashMap map = new HashMap();
            for (MapEntry entry : (List)fieldValue) {
                map.put(keyConverter.forwardConverter().convert(entry.getKey()), valueConverter.forwardConverter().convert(entry.getValue()));
            }
            return Optional.of(map);
        }
        if (fieldDescriptor.isRepeated()) {
            BidiConverter bidiConverter = this.fieldToValueConverter(fieldDescriptor);
            if (bidiConverter == BidiConverter.IDENTITY) {
                return Optional.of(fieldValue);
            }
            return Optional.of(AdaptingTypes.adaptingList((List)fieldValue, bidiConverter));
        }
        return Optional.of(this.fieldToValueConverter(fieldDescriptor).forwardConverter().convert(fieldValue));
    }

    public Optional<Object> adaptValueToFieldType(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue) {
        if (ProtoAdapter.isWrapperType(fieldDescriptor) && fieldValue.equals(NullValue.NULL_VALUE)) {
            return Optional.empty();
        }
        if (ProtoAdapter.isUnknown(fieldValue)) {
            return Optional.of(fieldValue);
        }
        if (fieldDescriptor.isMapField()) {
            Descriptors.Descriptor entryDescriptor = fieldDescriptor.getMessageType();
            Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByNumber(2);
            BidiConverter keyConverter = this.fieldToValueConverter(keyDescriptor);
            BidiConverter valueConverter = this.fieldToValueConverter(valueDescriptor);
            ArrayList<MapEntry> mapEntries = new ArrayList<MapEntry>();
            MapEntry protoMapEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)entryDescriptor, (WireFormat.FieldType)keyDescriptor.getLiteType(), (Object)ProtoAdapter.getDefaultValueForMaybeMessage(keyDescriptor), (WireFormat.FieldType)valueDescriptor.getLiteType(), (Object)ProtoAdapter.getDefaultValueForMaybeMessage(valueDescriptor));
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                mapEntries.add(protoMapEntry.toBuilder().setKey(keyConverter.backwardConverter().convert(entry.getKey())).setValue(valueConverter.backwardConverter().convert(entry.getValue())).build());
            }
            return Optional.of(mapEntries);
        }
        if (fieldDescriptor.isRepeated()) {
            return Optional.of(AdaptingTypes.adaptingList((List)fieldValue, this.fieldToValueConverter(fieldDescriptor).reverse()));
        }
        return Optional.of(this.fieldToValueConverter(fieldDescriptor).backwardConverter().convert(fieldValue));
    }

    private BidiConverter fieldToValueConverter(Descriptors.FieldDescriptor fieldDescriptor) {
        switch (fieldDescriptor.getType()) {
            case SFIXED32: 
            case SINT32: 
            case INT32: {
                return INT_CONVERTER;
            }
            case FIXED32: 
            case UINT32: {
                if (this.enableUnsignedLongs) {
                    return UNSIGNED_UINT32_CONVERTER;
                }
                return SIGNED_UINT32_CONVERTER;
            }
            case FIXED64: 
            case UINT64: {
                if (this.enableUnsignedLongs) {
                    return UNSIGNED_UINT64_CONVERTER;
                }
                return BidiConverter.IDENTITY;
            }
            case FLOAT: {
                return DOUBLE_CONVERTER;
            }
            case ENUM: {
                return BidiConverter.of(value -> ((Descriptors.EnumValueDescriptor)value).getNumber(), number -> fieldDescriptor.getEnumType().findValueByNumberCreatingIfUnknown(number.intValue()));
            }
            case MESSAGE: {
                return BidiConverter.of(this::adaptProtoToValue, value -> (MessageOrBuilder)this.adaptValueToProto(value, fieldDescriptor.getMessageType().getFullName()).orElseThrow(() -> new IllegalStateException(String.format("value not convertible to proto: %s", value))));
            }
        }
        return BidiConverter.IDENTITY;
    }

    public Optional<Message> adaptValueToProto(Object value, String protoTypeName) {
        WellKnownProto wellKnownProto = WellKnownProto.getByDescriptorName(protoTypeName);
        if (wellKnownProto == null) {
            if (value instanceof Message) {
                return Optional.of((Message)value);
            }
            return Optional.empty();
        }
        switch (wellKnownProto) {
            case ANY_VALUE: {
                return Optional.ofNullable(this.adaptValueToAny(value));
            }
            case JSON_VALUE: {
                return Optional.ofNullable(this.adaptValueToJsonValue(value));
            }
            case JSON_LIST_VALUE: {
                return Optional.ofNullable(this.adaptValueToJsonListValue(value));
            }
            case JSON_STRUCT_VALUE: {
                return Optional.ofNullable(this.adaptValueToJsonStructValue(value));
            }
            case BOOL_VALUE: {
                if (!(value instanceof Boolean)) break;
                return Optional.of(BoolValue.of((boolean)((Boolean)value)));
            }
            case BYTES_VALUE: {
                if (!(value instanceof ByteString)) break;
                return Optional.of(BytesValue.of((ByteString)((ByteString)value)));
            }
            case DOUBLE_VALUE: {
                return Optional.ofNullable(this.adaptValueToDouble(value));
            }
            case DURATION_VALUE: {
                return Optional.of((Duration)value);
            }
            case FLOAT_VALUE: {
                return Optional.ofNullable(this.adaptValueToFloat(value));
            }
            case INT32_VALUE: {
                return Optional.ofNullable(this.adaptValueToInt32(value));
            }
            case INT64_VALUE: {
                return Optional.ofNullable(this.adaptValueToInt64(value));
            }
            case STRING_VALUE: {
                if (!(value instanceof String)) break;
                return Optional.of(StringValue.of((String)((String)value)));
            }
            case TIMESTAMP_VALUE: {
                return Optional.of((Timestamp)value);
            }
            case UINT32_VALUE: {
                return Optional.ofNullable(this.adaptValueToUint32(value));
            }
            case UINT64_VALUE: {
                return Optional.ofNullable(this.adaptValueToUint64(value));
            }
        }
        return Optional.empty();
    }

    private @Nullable Message adaptValueToAny(Object value) {
        if (value == null || value instanceof NullValue) {
            return Any.pack((Message)Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build());
        }
        if (value instanceof Boolean) {
            return this.maybePackAny(value, WellKnownProto.BOOL_VALUE);
        }
        if (value instanceof ByteString) {
            return this.maybePackAny(value, WellKnownProto.BYTES_VALUE);
        }
        if (value instanceof Double) {
            return this.maybePackAny(value, WellKnownProto.DOUBLE_VALUE);
        }
        if (value instanceof Float) {
            return this.maybePackAny(value, WellKnownProto.FLOAT_VALUE);
        }
        if (value instanceof Integer) {
            return this.maybePackAny(value, WellKnownProto.INT32_VALUE);
        }
        if (value instanceof Long) {
            return this.maybePackAny(value, WellKnownProto.INT64_VALUE);
        }
        if (value instanceof Message) {
            return Any.pack((Message)((Message)value));
        }
        if (value instanceof Iterable) {
            return this.maybePackAny(value, WellKnownProto.JSON_LIST_VALUE);
        }
        if (value instanceof Map) {
            return this.maybePackAny(value, WellKnownProto.JSON_STRUCT_VALUE);
        }
        if (value instanceof String) {
            return this.maybePackAny(value, WellKnownProto.STRING_VALUE);
        }
        if (value instanceof UnsignedLong) {
            return this.maybePackAny(value, WellKnownProto.UINT64_VALUE);
        }
        return null;
    }

    private @Nullable Any maybePackAny(Object value, WellKnownProto wellKnownProto) {
        Optional<Message> protoValue = this.adaptValueToProto(value, wellKnownProto.typeName());
        if (protoValue.isPresent()) {
            return Any.pack((Message)protoValue.get());
        }
        return null;
    }

    private @Nullable Value adaptValueToJsonValue(Object value) {
        ListValue listValue;
        Struct struct;
        Value.Builder json = Value.newBuilder();
        if (value == null || value instanceof NullValue) {
            return json.setNullValue(NullValue.NULL_VALUE).build();
        }
        if (value instanceof Boolean) {
            return json.setBoolValue(((Boolean)value).booleanValue()).build();
        }
        if (value instanceof Integer || value instanceof Long) {
            long longValue = ((Number)value).longValue();
            if (longValue < -9007199254740991L || longValue > 0x1FFFFFFFFFFFFFL) {
                return json.setStringValue(Long.toString(longValue)).build();
            }
            return json.setNumberValue((double)longValue).build();
        }
        if (value instanceof UnsignedLong) {
            if (((UnsignedLong)value).compareTo(JSON_MAX_UINT_VALUE) > 0) {
                return json.setStringValue(((UnsignedLong)value).toString()).build();
            }
            return json.setNumberValue((double)((UnsignedLong)value).longValue()).build();
        }
        if (value instanceof Float || value instanceof Double) {
            return json.setNumberValue(((Number)value).doubleValue()).build();
        }
        if (value instanceof ByteString) {
            return json.setStringValue(Base64.getEncoder().encodeToString(((ByteString)value).toByteArray())).build();
        }
        if (value instanceof String) {
            return json.setStringValue((String)value).build();
        }
        if (value instanceof Map && (struct = this.adaptValueToJsonStructValue(value)) != null) {
            return json.setStructValue(struct).build();
        }
        if (value instanceof Iterable && (listValue = this.adaptValueToJsonListValue(value)) != null) {
            return json.setListValue(listValue).build();
        }
        return null;
    }

    private @Nullable ListValue adaptValueToJsonListValue(Object value) {
        if (!(value instanceof Iterable)) {
            return null;
        }
        Iterable list = (Iterable)value;
        ListValue.Builder jsonList = ListValue.newBuilder();
        for (Object elem : list) {
            jsonList.addValues(this.adaptValueToJsonValue(elem));
        }
        return jsonList.build();
    }

    private @Nullable Struct adaptValueToJsonStructValue(Object value) {
        if (!(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        Struct.Builder struct = Struct.newBuilder();
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object keyValue = entry.getValue();
            if (!(key instanceof String)) {
                return null;
            }
            struct.putFields((String)key, this.adaptValueToJsonValue(keyValue));
        }
        return struct.build();
    }

    private @Nullable Message adaptValueToDouble(Object value) {
        if (value instanceof Double) {
            return DoubleValue.of((double)((Double)value));
        }
        if (value instanceof Float) {
            return DoubleValue.of((double)((Float)value).doubleValue());
        }
        return null;
    }

    private @Nullable Message adaptValueToFloat(Object value) {
        if (value instanceof Double) {
            return FloatValue.of((float)((Double)value).floatValue());
        }
        if (value instanceof Float) {
            return FloatValue.of((float)((Float)value).floatValue());
        }
        return null;
    }

    private @Nullable Message adaptValueToInt32(Object value) {
        if (value instanceof Integer) {
            return Int32Value.of((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Int32Value.of((int)ProtoAdapter.intCheckedCast((Long)value));
        }
        return null;
    }

    private @Nullable Message adaptValueToInt64(Object value) {
        if (value instanceof Integer) {
            return Int64Value.of((long)((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return Int64Value.of((long)((Long)value));
        }
        return null;
    }

    private @Nullable Message adaptValueToUint32(Object value) {
        if (value instanceof Integer) {
            return UInt32Value.of((int)((Integer)value));
        }
        if (value instanceof Long) {
            try {
                return UInt32Value.of((int)ProtoAdapter.unsignedIntCheckedCast((Long)value));
            }
            catch (IllegalArgumentException e) {
                throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
            }
        }
        if (value instanceof UnsignedLong) {
            try {
                return UInt32Value.of((int)ProtoAdapter.unsignedIntCheckedCast(((UnsignedLong)value).longValue()));
            }
            catch (IllegalArgumentException e) {
                throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
            }
        }
        return null;
    }

    private @Nullable Message adaptValueToUint64(Object value) {
        if (value instanceof Integer) {
            return UInt64Value.of((long)UnsignedInts.toLong((int)((Integer)value)));
        }
        if (value instanceof Long) {
            return UInt64Value.of((long)((Long)value));
        }
        if (value instanceof UnsignedLong) {
            return UInt64Value.of((long)((UnsignedLong)value).longValue());
        }
        return null;
    }

    private @Nullable Object adaptJsonToValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case NULL_VALUE: {
                return value.getNullValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case LIST_VALUE: {
                return this.adaptJsonListToValue(value.getListValue());
            }
            case STRUCT_VALUE: {
                return this.adaptJsonStructToValue(value.getStructValue());
            }
            case KIND_NOT_SET: {
                return NullValue.NULL_VALUE;
            }
        }
        return null;
    }

    private Object unpackAnyProto(Any anyProto) {
        try {
            return this.adaptProtoToValue((MessageOrBuilder)this.dynamicProto.unpack(anyProto));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ImmutableList<Object> adaptJsonListToValue(ListValue listValue) {
        return (ImmutableList)listValue.getValuesList().stream().map(this::adaptJsonToValue).collect(ImmutableList.toImmutableList());
    }

    private ImmutableMap<String, Object> adaptJsonStructToValue(Struct struct) {
        return (ImmutableMap)struct.getFieldsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> this.adaptJsonToValue((Value)e.getValue())));
    }

    private static Object getDefaultValueForMaybeMessage(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return DynamicMessage.getDefaultInstance((Descriptors.Descriptor)descriptor.getMessageType());
        }
        return descriptor.getDefaultValue();
    }

    private static String typeName(Descriptors.Descriptor protoType) {
        return protoType.getFullName();
    }

    private static boolean isWrapperType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return false;
        }
        String fieldTypeName = fieldDescriptor.getMessageType().getFullName();
        WellKnownProto wellKnownProto = WellKnownProto.getByDescriptorName(fieldTypeName);
        return wellKnownProto != null && wellKnownProto.isWrapperType();
    }

    private static boolean isUnknown(Object object) {
        return object instanceof ExprValue && ((ExprValue)object).getKindCase() == ExprValue.KindCase.UNKNOWN;
    }

    private static int intCheckedCast(long value) {
        try {
            return Ints.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }

    private static int unsignedIntCheckedCast(long value) {
        try {
            return UnsignedInts.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new CelRuntimeException(e, CelErrorCode.NUMERIC_OVERFLOW);
        }
    }
}

