/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.AutoValue_ProtoEquality_ProtoMap;
import dev.cel.common.internal.DynamicProto;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@CheckReturnValue
@Immutable
@Internal
public final class ProtoEquality {
    private static final String ANY_FULL_NAME = Any.getDescriptor().getFullName();
    private final DynamicProto dynamicProto;

    public ProtoEquality(DynamicProto dynamicProto) {
        this.dynamicProto = dynamicProto;
    }

    public boolean equals(Message message1, Message message2) {
        if (message1 == message2) {
            return true;
        }
        if (!message1.getDescriptorForType().equals(message2.getDescriptorForType())) {
            return false;
        }
        if (ProtoEquality.isAny(message1)) {
            Optional<Message> unpackedAny1 = this.dynamicProto.maybeUnpackAny(message1);
            Optional<Message> unpackedAny2 = this.dynamicProto.maybeUnpackAny(message2);
            if (unpackedAny1.isPresent() && unpackedAny2.isPresent()) {
                return this.equals(unpackedAny1.get(), unpackedAny2.get());
            }
            return this.anyValue(message1).equals((Object)this.anyValue(message2));
        }
        if (!message1.getUnknownFields().equals((Object)message2.getUnknownFields())) {
            return false;
        }
        Map message1Fields = message1.getAllFields();
        Map message2Fields = message2.getAllFields();
        if (message1Fields.size() != message2Fields.size()) {
            return false;
        }
        for (Map.Entry entry : message1Fields.entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)entry.getKey();
            Object value1 = entry.getValue();
            Object value2 = message2Fields.get(entry.getKey());
            if (value2 == null) {
                return false;
            }
            if (field.isMapField()) {
                List mapEntries1 = (List)value1;
                List mapEntries2 = (List)value2;
                if (mapEntries1.size() != mapEntries2.size()) {
                    return false;
                }
                ProtoMap protoMap1 = ProtoEquality.protoMap(mapEntries1);
                ProtoMap protoMap2 = ProtoEquality.protoMap(mapEntries2);
                if (!protoMap1.valueField().equals(protoMap2.valueField())) {
                    return false;
                }
                for (Map.Entry mapEntry1 : protoMap1.map().entrySet()) {
                    Object mapKey = mapEntry1.getKey();
                    Object mapValue1 = mapEntry1.getValue();
                    if (!protoMap2.map().containsKey(mapKey)) {
                        return false;
                    }
                    Object mapValue2 = protoMap2.map().get(mapKey);
                    if (this.equalsFieldValues(protoMap1.valueField(), mapValue1, mapValue2)) continue;
                    return false;
                }
                continue;
            }
            if (!(field.isRepeated() ? !this.equalsRepeatedFieldValues(field, (List)value1, (List)value2) : !this.equalsFieldValues(field, value1, value2))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsFieldValues(Descriptors.FieldDescriptor field, Object value1, Object value2) {
        switch (field.getJavaType()) {
            case MESSAGE: {
                return this.equals((Message)value1, (Message)value2);
            }
            case DOUBLE: 
            case FLOAT: {
                Number num1 = (Number)value1;
                Number num2 = (Number)value2;
                boolean num1IsNaN = Double.isNaN(num1.doubleValue());
                boolean num2IsNaN = Double.isNaN(num2.doubleValue());
                if (num1IsNaN && num2IsNaN) {
                    return false;
                }
                return num1.equals(num2);
            }
        }
        return value1.equals(value2);
    }

    private boolean equalsRepeatedFieldValues(Descriptors.FieldDescriptor field, List<?> value1, List<?> value2) {
        if (value1.size() != value2.size()) {
            return false;
        }
        for (int i = 0; i < value1.size(); ++i) {
            Object elem2;
            Object elem1 = value1.get(i);
            if (this.equalsFieldValues(field, elem1, elem2 = value2.get(i))) continue;
            return false;
        }
        return true;
    }

    private ByteString anyValue(Message msg) {
        Descriptors.FieldDescriptor value = msg.getDescriptorForType().findFieldByName("value");
        return (ByteString)msg.getField(value);
    }

    private static ProtoMap protoMap(List<?> entries) {
        ImmutableMap.Builder protoMap = ImmutableMap.builder();
        Descriptors.FieldDescriptor keyField = null;
        Descriptors.FieldDescriptor valueField = null;
        for (Object entry : entries) {
            Message mapEntry = (Message)entry;
            if (keyField == null && valueField == null) {
                Descriptors.Descriptor descriptor = mapEntry.getDescriptorForType();
                keyField = descriptor.findFieldByNumber(1);
                valueField = descriptor.findFieldByNumber(2);
            }
            protoMap.put(mapEntry.getField(keyField), mapEntry.getField(valueField));
        }
        return ProtoMap.create(valueField, (ImmutableMap<Object, Object>)protoMap.buildOrThrow());
    }

    private static boolean isAny(Message msg) {
        return msg instanceof Any || msg.getDescriptorForType().getFullName().equals(ANY_FULL_NAME);
    }

    @AutoValue
    static abstract class ProtoMap {
        ProtoMap() {
        }

        abstract Descriptors.FieldDescriptor valueField();

        abstract ImmutableMap<Object, Object> map();

        static ProtoMap create(Descriptors.FieldDescriptor valueField, ImmutableMap<Object, Object> map) {
            return new AutoValue_ProtoEquality_ProtoMap(valueField, map);
        }
    }
}

