/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;

@Immutable
@VisibleForTesting
@Internal
public final class SupplementalCodePointArray
extends CelCodePointArray {
    private final int[] codePoints;
    private final int offset;
    private final int size;

    SupplementalCodePointArray(int[] codePoints, int size) {
        this(codePoints, 0, size);
    }

    SupplementalCodePointArray(int[] codePoints, int offset, int size) {
        this.codePoints = (int[])Preconditions.checkNotNull((Object)codePoints);
        this.offset = offset;
        this.size = size;
    }

    @Override
    public SupplementalCodePointArray slice(int i, int j) {
        Preconditions.checkPositionIndexes((int)i, (int)j, (int)this.size());
        return new SupplementalCodePointArray(this.codePoints, this.offset + i, j - i);
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size());
        return this.codePoints[this.offset + index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return new String(this.codePoints, this.offset, this.size);
    }
}

