/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import dev.cel.common.annotations.Internal;
import java.util.Arrays;
import java.util.function.Function;

@Internal
public enum WellKnownProto {
    JSON_VALUE(Value.getDescriptor()),
    JSON_STRUCT_VALUE(Struct.getDescriptor()),
    JSON_LIST_VALUE(ListValue.getDescriptor()),
    ANY_VALUE(Any.getDescriptor()),
    BOOL_VALUE(BoolValue.getDescriptor(), true),
    BYTES_VALUE(BytesValue.getDescriptor(), true),
    DOUBLE_VALUE(DoubleValue.getDescriptor(), true),
    FLOAT_VALUE(FloatValue.getDescriptor(), true),
    INT32_VALUE(Int32Value.getDescriptor(), true),
    INT64_VALUE(Int64Value.getDescriptor(), true),
    STRING_VALUE(StringValue.getDescriptor(), true),
    UINT32_VALUE(UInt32Value.getDescriptor(), true),
    UINT64_VALUE(UInt64Value.getDescriptor(), true),
    DURATION_VALUE(Duration.getDescriptor()),
    TIMESTAMP_VALUE(Timestamp.getDescriptor());

    private final Descriptors.Descriptor descriptor;
    private final boolean isWrapperType;
    private static final ImmutableMap<String, WellKnownProto> WELL_KNOWN_PROTO_MAP;

    private WellKnownProto(Descriptors.Descriptor descriptor) {
        this(descriptor, false);
    }

    private WellKnownProto(Descriptors.Descriptor descriptor, boolean isWrapperType) {
        this.descriptor = descriptor;
        this.isWrapperType = isWrapperType;
    }

    public Descriptors.Descriptor descriptor() {
        return this.descriptor;
    }

    public String typeName() {
        return this.descriptor.getFullName();
    }

    public boolean isWrapperType() {
        return this.isWrapperType;
    }

    public static WellKnownProto getByDescriptorName(String name) {
        return (WellKnownProto)((Object)WELL_KNOWN_PROTO_MAP.get((Object)name));
    }

    static {
        WELL_KNOWN_PROTO_MAP = (ImmutableMap)Arrays.stream(WellKnownProto.values()).collect(ImmutableMap.toImmutableMap(WellKnownProto::typeName, Function.identity()));
    }
}

