/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import java.util.Map;
import java.util.Optional;

@CheckReturnValue
public final class EnumType
extends CelType {
    private final String name;
    private final EnumNumberResolver enumNumberResolver;
    private final EnumNameResolver enumNameResolver;

    EnumType(String name, EnumNumberResolver enumNumberResolver, EnumNameResolver enumNameResolver) {
        this.name = name;
        this.enumNumberResolver = enumNumberResolver;
        this.enumNameResolver = enumNameResolver;
    }

    @Override
    public CelKind kind() {
        return CelKind.INT;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isAssignableFrom(CelType other) {
        return super.isAssignableFrom(other) || other.kind().equals((Object)CelKind.INT);
    }

    public Optional<Integer> findNumberByName(String enumName) {
        return this.enumNumberResolver.findNumber(enumName);
    }

    public Optional<String> findNameByNumber(Integer enumNumber) {
        return this.enumNameResolver.findName(enumNumber);
    }

    public static EnumType create(String name, ImmutableMap<String, Integer> enumNameToNumber) {
        return EnumType.create(name, enumName -> Optional.ofNullable((Integer)enumNameToNumber.get((Object)enumName)), num -> enumNameToNumber.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(num)).findFirst().map(Map.Entry::getKey));
    }

    public static EnumType create(String name, EnumNumberResolver enumNumberResolver, EnumNameResolver enumNameResolver) {
        return new EnumType(name, enumNumberResolver, enumNameResolver);
    }

    @Immutable
    @FunctionalInterface
    public static interface EnumNumberResolver {
        public Optional<Integer> findNumber(String var1);
    }

    @Immutable
    @FunctionalInterface
    public static interface EnumNameResolver {
        public Optional<String> findName(Integer var1);
    }
}

