/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_SimpleType;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.EnumType;
import dev.cel.common.types.NullableType;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class SimpleType
extends CelType {
    public static final CelType ERROR = SimpleType.create(CelKind.ERROR, "*error*");
    public static final CelType DYN = SimpleType.create(CelKind.DYN, "dyn");
    public static final CelType ANY = SimpleType.create(CelKind.ANY, "google.protobuf.Any");
    public static final CelType BOOL = SimpleType.create(CelKind.BOOL, "bool");
    public static final CelType BYTES = SimpleType.create(CelKind.BYTES, "bytes");
    public static final CelType DOUBLE = SimpleType.create(CelKind.DOUBLE, "double");
    public static final CelType DURATION = SimpleType.create(CelKind.DURATION, "google.protobuf.Duration");
    public static final CelType INT = SimpleType.create(CelKind.INT, "int");
    public static final CelType NULL_TYPE = SimpleType.create(CelKind.NULL_TYPE, "null_type");
    public static final CelType STRING = SimpleType.create(CelKind.STRING, "string");
    public static final CelType TIMESTAMP = SimpleType.create(CelKind.TIMESTAMP, "google.protobuf.Timestamp");
    public static final CelType UINT = SimpleType.create(CelKind.UINT, "uint");

    @Override
    public abstract CelKind kind();

    @Override
    public abstract String name();

    @Override
    public boolean isAssignableFrom(CelType other) {
        return this.kind().isDyn() || super.isAssignableFrom(other) || this.kind().equals((Object)CelKind.INT) && other instanceof EnumType || other instanceof NullableType && other.isAssignableFrom(this);
    }

    private static CelType create(CelKind kind, String name) {
        return new AutoValue_SimpleType(kind, name);
    }
}

