/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.values.CelValue;
import java.util.Map;
import java.util.Optional;

@Immutable
public interface CelValueProvider {
    public Optional<CelValue> newValue(String var1, Map<String, Object> var2);

    @Immutable
    public static final class CombinedCelValueProvider
    implements CelValueProvider {
        private final ImmutableList<CelValueProvider> celValueProviders;

        public CombinedCelValueProvider(CelValueProvider first, CelValueProvider second) {
            Preconditions.checkNotNull((Object)first);
            Preconditions.checkNotNull((Object)second);
            this.celValueProviders = ImmutableList.of((Object)first, (Object)second);
        }

        @Override
        public Optional<CelValue> newValue(String structType, Map<String, Object> fields) {
            for (CelValueProvider provider : this.celValueProviders) {
                Optional<CelValue> newValue = provider.newValue(structType, fields);
                if (!newValue.isPresent()) continue;
                return newValue;
            }
            return Optional.empty();
        }
    }
}

