/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.ListValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Immutable
public final class ImmutableListValue<E extends CelValue>
extends ListValue<E> {
    private final List<E> originalList;
    private volatile ImmutableList<E> cachedImmutableList = null;

    public static <E extends CelValue> ImmutableListValue<E> create(List<E> value) {
        return new ImmutableListValue<E>(value);
    }

    private ImmutableListValue(List<E> originalList) {
        this.originalList = ImmutableList.copyOf(originalList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableList<E> value() {
        if (this.cachedImmutableList == null) {
            ImmutableListValue immutableListValue = this;
            synchronized (immutableListValue) {
                if (this.cachedImmutableList == null) {
                    this.cachedImmutableList = ImmutableList.copyOf(this.originalList);
                }
            }
        }
        return this.cachedImmutableList;
    }

    @Override
    public int size() {
        return this.originalList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.originalList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.originalList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.originalList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.originalList.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.originalList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return (E)((CelValue)this.originalList.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.originalList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.originalList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.originalList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.originalList.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.originalList.subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return this.originalList.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.originalList.equals(obj);
    }
}

