/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.values.AutoValue_OptionalValue;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.SelectableValue;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@Immutable(containerOf={"E"})
@AutoValue
public abstract class OptionalValue<E extends CelValue>
extends CelValue
implements SelectableValue<CelValue> {
    private static final OptionalType OPTIONAL_TYPE = OptionalType.create(SimpleType.DYN);
    public static final OptionalValue<CelValue> EMPTY = OptionalValue.empty();

    abstract @Nullable E innerValue();

    public E value() {
        if (this.innerValue() == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.innerValue();
    }

    @Override
    public boolean isZeroValue() {
        return this.innerValue() == null;
    }

    @Override
    public OptionalType celType() {
        return OPTIONAL_TYPE;
    }

    @Override
    public CelValue select(CelValue field) {
        return this.find(field).orElse(EMPTY);
    }

    @Override
    public Optional<CelValue> find(CelValue field) {
        if (this.isZeroValue()) {
            return Optional.empty();
        }
        SelectableValue selectableValue = (SelectableValue)this.value();
        Optional<CelValue> selectedField = selectableValue.find(field);
        return selectedField.map(OptionalValue::create);
    }

    public static <E extends CelValue> OptionalValue<E> create(E value) {
        Preconditions.checkNotNull(value);
        return new AutoValue_OptionalValue<E>(value);
    }

    private static OptionalValue<CelValue> empty() {
        return new AutoValue_OptionalValue<Object>(null);
    }
}

