/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.WellKnownProto;
import dev.cel.common.types.CelTypes;
import dev.cel.common.values.BytesValue;
import dev.cel.common.values.CelByteString;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueConverter;
import dev.cel.common.values.DurationValue;
import dev.cel.common.values.ImmutableListValue;
import dev.cel.common.values.ImmutableMapValue;
import dev.cel.common.values.IntValue;
import dev.cel.common.values.ListValue;
import dev.cel.common.values.MapValue;
import dev.cel.common.values.NullValue;
import dev.cel.common.values.ProtoMessageValue;
import dev.cel.common.values.TimestampValue;
import dev.cel.common.values.UintValue;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
@Internal
public final class ProtoCelValueConverter
extends CelValueConverter {
    private final CelDescriptorPool celDescriptorPool;
    private final DynamicProto dynamicProto;

    public static ProtoCelValueConverter newInstance(CelOptions celOptions, CelDescriptorPool celDescriptorPool, DynamicProto dynamicProto) {
        return new ProtoCelValueConverter(celOptions, celDescriptorPool, dynamicProto);
    }

    @Override
    public Object fromCelValueToJavaObject(CelValue celValue) {
        Preconditions.checkNotNull((Object)celValue);
        if (celValue instanceof TimestampValue) {
            return TimeUtils.toProtoTimestamp(((TimestampValue)celValue).value());
        }
        if (celValue instanceof DurationValue) {
            return TimeUtils.toProtoDuration(((DurationValue)celValue).value());
        }
        if (celValue instanceof BytesValue) {
            return ByteString.copyFrom((byte[])((BytesValue)celValue).value().toByteArray());
        }
        if (NullValue.NULL_VALUE.equals(celValue)) {
            return com.google.protobuf.NullValue.NULL_VALUE;
        }
        return super.fromCelValueToJavaObject(celValue);
    }

    public CelValue fromProtoMessageToCelValue(MessageOrBuilder message) {
        WellKnownProto wellKnownProto;
        Preconditions.checkNotNull((Object)message);
        if (message instanceof DynamicMessage) {
            message = this.dynamicProto.maybeAdaptDynamicMessage((DynamicMessage)message);
        }
        if ((wellKnownProto = WellKnownProto.getByDescriptorName(message.getDescriptorForType().getFullName())) == null) {
            return ProtoMessageValue.create((Message)message, this.celDescriptorPool, this);
        }
        switch (wellKnownProto) {
            case ANY_VALUE: {
                Message unpackedMessage;
                try {
                    unpackedMessage = this.dynamicProto.unpack((Any)message);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalStateException("Unpacking failed for message: " + message.getDescriptorForType().getFullName(), e);
                }
                return this.fromProtoMessageToCelValue((MessageOrBuilder)unpackedMessage);
            }
            case JSON_VALUE: {
                return this.adaptJsonValueToCelValue((Value)message);
            }
            case JSON_STRUCT_VALUE: {
                return this.adaptJsonStructToCelValue((Struct)message);
            }
            case JSON_LIST_VALUE: {
                return this.adaptJsonListToCelValue((com.google.protobuf.ListValue)message);
            }
            case DURATION_VALUE: {
                return DurationValue.create(TimeUtils.toJavaDuration((Duration)message));
            }
            case TIMESTAMP_VALUE: {
                return TimestampValue.create(TimeUtils.toJavaInstant((Timestamp)message));
            }
            case BOOL_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((BoolValue)message).getValue());
            }
            case BYTES_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((com.google.protobuf.BytesValue)message).getValue().toByteArray());
            }
            case DOUBLE_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((DoubleValue)message).getValue());
            }
            case FLOAT_VALUE: {
                return this.fromJavaPrimitiveToCelValue(Float.valueOf(((FloatValue)message).getValue()));
            }
            case INT32_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((Int32Value)message).getValue());
            }
            case INT64_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((Int64Value)message).getValue());
            }
            case STRING_VALUE: {
                return this.fromJavaPrimitiveToCelValue(((StringValue)message).getValue());
            }
            case UINT32_VALUE: {
                return UintValue.create(((UInt32Value)message).getValue(), this.celOptions.enableUnsignedLongs());
            }
            case UINT64_VALUE: {
                return UintValue.create(((UInt64Value)message).getValue(), this.celOptions.enableUnsignedLongs());
            }
        }
        throw new UnsupportedOperationException("Unsupported message to CelValue conversion - " + message);
    }

    @Override
    public CelValue fromJavaObjectToCelValue(Object value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof Message) {
            return this.fromProtoMessageToCelValue((MessageOrBuilder)((Message)value));
        }
        if (value instanceof Message.Builder) {
            Message.Builder msgBuilder = (Message.Builder)value;
            return this.fromProtoMessageToCelValue((MessageOrBuilder)msgBuilder.build());
        }
        if (value instanceof ByteString) {
            return BytesValue.create(CelByteString.of(((ByteString)value).toByteArray()));
        }
        if (value instanceof com.google.protobuf.NullValue) {
            return NullValue.NULL_VALUE;
        }
        if (value instanceof Descriptors.EnumValueDescriptor) {
            return IntValue.create(((Descriptors.EnumValueDescriptor)value).getNumber());
        }
        return super.fromJavaObjectToCelValue(value);
    }

    public CelValue fromProtoMessageFieldToCelValue(Message message, Descriptors.FieldDescriptor fieldDescriptor) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)fieldDescriptor);
        Object result = message.getField(fieldDescriptor);
        switch (fieldDescriptor.getType()) {
            case MESSAGE: {
                if (CelTypes.isWrapperType(fieldDescriptor.getMessageType().getFullName()) && !message.hasField(fieldDescriptor)) {
                    return NullValue.NULL_VALUE;
                }
                if (!fieldDescriptor.isMapField()) break;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (MapEntry entry : (List)result) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return this.fromJavaObjectToCelValue(map);
            }
            case UINT32: {
                return UintValue.create(((Integer)result).intValue(), this.celOptions.enableUnsignedLongs());
            }
            case UINT64: {
                return UintValue.create((Long)result, this.celOptions.enableUnsignedLongs());
            }
        }
        return this.fromJavaObjectToCelValue(result);
    }

    private CelValue adaptJsonValueToCelValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getBoolValue());
            }
            case NUMBER_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getNumberValue());
            }
            case STRING_VALUE: {
                return this.fromJavaPrimitiveToCelValue(value.getStringValue());
            }
            case LIST_VALUE: {
                return this.adaptJsonListToCelValue(value.getListValue());
            }
            case STRUCT_VALUE: {
                return this.adaptJsonStructToCelValue(value.getStructValue());
            }
            case NULL_VALUE: 
            case KIND_NOT_SET: {
                return NullValue.NULL_VALUE;
            }
        }
        throw new UnsupportedOperationException("Unsupported Json to CelValue conversion: " + value.getKindCase());
    }

    private ListValue<CelValue> adaptJsonListToCelValue(com.google.protobuf.ListValue listValue) {
        return ImmutableListValue.create((List)listValue.getValuesList().stream().map(this::adaptJsonValueToCelValue).collect(ImmutableList.toImmutableList()));
    }

    private MapValue<CelValue, CelValue> adaptJsonStructToCelValue(Struct struct) {
        return ImmutableMapValue.create((Map)struct.getFieldsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> this.fromJavaObjectToCelValue(e.getKey()), e -> this.adaptJsonValueToCelValue((Value)e.getValue()))));
    }

    private ProtoCelValueConverter(CelOptions celOptions, CelDescriptorPool celDescriptorPool, DynamicProto dynamicProto) {
        super(celOptions);
        Preconditions.checkNotNull((Object)celDescriptorPool);
        Preconditions.checkNotNull((Object)dynamicProto);
        this.celDescriptorPool = celDescriptorPool;
        this.dynamicProto = dynamicProto;
    }

    private static class TimeUtils {
        private static final int NANOS_PER_SECOND = 1000000000;

        private TimeUtils() {
        }

        private static Instant toJavaInstant(Timestamp timestamp) {
            timestamp = TimeUtils.normalizedTimestamp(timestamp.getSeconds(), timestamp.getNanos());
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }

        private static java.time.Duration toJavaDuration(Duration duration) {
            duration = TimeUtils.normalizedDuration(duration.getSeconds(), duration.getNanos());
            return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
        }

        private static Timestamp toProtoTimestamp(Instant instant) {
            return TimeUtils.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
        }

        private static Duration toProtoDuration(java.time.Duration duration) {
            return TimeUtils.normalizedDuration(duration.getSeconds(), duration.getNano());
        }

        private static Timestamp normalizedTimestamp(long seconds, int nanos) {
            if (nanos <= -1000000000 || nanos >= 1000000000) {
                seconds = LongMath.checkedAdd((long)seconds, (long)(nanos / 1000000000));
                nanos %= 1000000000;
            }
            if (nanos < 0) {
                nanos += 1000000000;
                seconds = LongMath.checkedSubtract((long)seconds, (long)1L);
            }
            Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
            return Timestamps.checkValid((Timestamp)timestamp);
        }

        private static Duration normalizedDuration(long seconds, int nanos) {
            if (nanos <= -1000000000 || nanos >= 1000000000) {
                seconds = LongMath.checkedAdd((long)seconds, (long)(nanos / 1000000000));
                nanos %= 1000000000;
            }
            if (seconds > 0L && nanos < 0) {
                nanos += 1000000000;
                --seconds;
            }
            if (seconds < 0L && nanos > 0) {
                nanos -= 1000000000;
                ++seconds;
            }
            Duration duration = Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
            return Durations.checkValid((Duration)duration);
        }
    }
}

