/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoAdapter;
import dev.cel.common.internal.ProtoMessageFactory;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueProvider;
import dev.cel.common.values.ProtoCelValueConverter;
import java.util.Map;
import java.util.Optional;

@Immutable
@Internal
public class ProtoMessageValueProvider
implements CelValueProvider {
    private final ProtoAdapter protoAdapter;
    private final ProtoMessageFactory protoMessageFactory;
    private final ProtoCelValueConverter protoCelValueConverter;

    @Override
    public Optional<CelValue> newValue(String structType, Map<String, Object> fields) {
        try {
            Message.Builder builder = this.getMessageBuilderOrThrow(structType);
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = this.findField(descriptor, entry.getKey());
                Optional<Object> fieldValue = this.protoAdapter.adaptValueToFieldType(fieldDescriptor, entry.getValue());
                fieldValue.ifPresent(o -> builder.setField(fieldDescriptor, o));
            }
            return Optional.of(this.protoCelValueConverter.fromProtoMessageToCelValue((MessageOrBuilder)builder.build()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Message.Builder getMessageBuilderOrThrow(String messageName) {
        return this.protoMessageFactory.newBuilder(messageName).orElseThrow(() -> new CelRuntimeException(new IllegalArgumentException(String.format("cannot resolve '%s' as a message", messageName)), CelErrorCode.ATTRIBUTE_NOT_FOUND));
    }

    private Descriptors.FieldDescriptor findField(Descriptors.Descriptor descriptor, String fieldName) {
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(fieldName);
        if (fieldDescriptor != null) {
            return fieldDescriptor;
        }
        return this.protoMessageFactory.getDescriptorPool().findExtensionDescriptor(descriptor, fieldName).orElseThrow(() -> new IllegalArgumentException(String.format("field '%s' is not declared in message '%s'", fieldName, descriptor.getFullName())));
    }

    public static ProtoMessageValueProvider newInstance(DynamicProto dynamicProto, CelOptions celOptions) {
        return new ProtoMessageValueProvider(dynamicProto, celOptions);
    }

    private ProtoMessageValueProvider(DynamicProto dynamicProto, CelOptions celOptions) {
        this.protoMessageFactory = dynamicProto.getProtoMessageFactory();
        this.protoCelValueConverter = ProtoCelValueConverter.newInstance(celOptions, this.protoMessageFactory.getDescriptorPool(), dynamicProto);
        this.protoAdapter = new ProtoAdapter(dynamicProto, celOptions.enableUnsignedLongs());
    }
}

