/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.values;

import com.google.auto.value.AutoValue;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.values.AutoValue_UintValue;
import dev.cel.common.values.CelValue;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class UintValue
extends CelValue {
    @Override
    public abstract Number value();

    @Override
    public boolean isZeroValue() {
        return this.value().longValue() == 0L;
    }

    @Override
    public CelType celType() {
        return SimpleType.UINT;
    }

    public static UintValue create(UnsignedLong value) {
        return new AutoValue_UintValue((Number)value);
    }

    public static UintValue create(long value, boolean enableUnsignedLongs) {
        Object unsignedLong = enableUnsignedLongs ? UnsignedLong.fromLongBits((long)value) : Long.valueOf(value);
        return new AutoValue_UintValue((Number)unsignedLong);
    }
}

