/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoAdapter;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.RuntimeHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@Internal
public abstract class Activation
implements GlobalResolver {
    public static final Activation EMPTY = new Activation(){

        @Override
        public @Nullable Object resolve(String name) {
            return null;
        }

        public String toString() {
            return "{}";
        }
    };

    @Override
    public abstract @Nullable Object resolve(String var1);

    public static Activation of(final String name, final Object value) {
        return new Activation(){

            @Override
            public @Nullable Object resolve(String theName) {
                if (theName.equals(name)) {
                    return RuntimeHelpers.maybeAdaptPrimitive(value);
                }
                return null;
            }

            public String toString() {
                if (value instanceof ByteString) {
                    ByteString bs = (ByteString)value;
                    StringBuilder val = new StringBuilder();
                    val.append("[");
                    ByteString.ByteIterator i = bs.iterator();
                    while (i.hasNext()) {
                        byte b = i.nextByte();
                        val.append(b);
                        if (!i.hasNext()) continue;
                        val.append(", ");
                    }
                    val.append("]");
                    return String.format("{%s=%s}", name, val);
                }
                return String.format("{%s=%s}", name, value);
            }
        };
    }

    public static Activation of(final String name, final Supplier<?> supplier) {
        return new Activation(){

            @Override
            public @Nullable Object resolve(String theName) {
                if (theName.equals(name)) {
                    return RuntimeHelpers.maybeAdaptPrimitive(supplier.get());
                }
                return null;
            }

            public String toString() {
                return String.format("{%s=%s}", name, supplier.get());
            }
        };
    }

    public static Activation copyOf(Map<String, ?> map) {
        final ImmutableMap copy = map instanceof ImmutableMap ? (ImmutableMap)map : (ImmutableMap)map.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Activation(){

            @Override
            public @Nullable Object resolve(String name) {
                return RuntimeHelpers.maybeAdaptPrimitive(copy.get((Object)name));
            }

            public String toString() {
                return copy.toString();
            }
        };
    }

    public static Activation fromProto(Message message) {
        return Activation.fromProto(message, CelOptions.LEGACY);
    }

    public static Activation fromProto(Message message, CelOptions celOptions) {
        HashMap<String, InterpreterException> variables = new HashMap<String, InterpreterException>();
        Map msgFieldValues = message.getAllFields();
        ProtoAdapter protoAdapter = new ProtoAdapter(DynamicProto.create(DefaultMessageFactory.INSTANCE), celOptions.enableUnsignedLongs());
        for (Descriptors.FieldDescriptor field : message.getDescriptorForType().getFields()) {
            Object fieldValue = msgFieldValues.getOrDefault(field, message.getField(field));
            try {
                Optional<Object> adapted = protoAdapter.adaptFieldToValue(field, fieldValue);
                variables.put(field.getName(), adapted.orElse(null));
            }
            catch (IllegalArgumentException e) {
                variables.put(field.getName(), new InterpreterException.Builder("illegal field value. field=%s, value=%s", field.getName(), fieldValue).setCause(e).build());
            }
        }
        return Activation.copyOf(variables);
    }

    public Activation extend(final Activation activation) {
        final Activation outer = this;
        return new Activation(){

            @Override
            public @Nullable Object resolve(String name) {
                Object value = activation.resolve(name);
                return value != null ? value : outer.resolve(name);
            }

            public String toString() {
                return activation + " +> " + outer;
            }
        };
    }
}

