/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.re2j.Pattern;
import dev.cel.runtime.AutoOneOf_CelAttribute_Qualifier;
import dev.cel.runtime.AutoValue_CelAttribute;

@Immutable
@AutoValue
public abstract class CelAttribute {
    public static final CelAttribute EMPTY = new AutoValue_CelAttribute((ImmutableList<Qualifier>)ImmutableList.of());

    public static CelAttribute create(ImmutableList<Qualifier> qualifiers) {
        Preconditions.checkArgument((!qualifiers.isEmpty() ? 1 : 0) != 0, (Object)"qualifiers must be non-empty");
        Preconditions.checkArgument((boolean)Qualifier.isLegalIdentifier((Qualifier)qualifiers.get(0)), (String)"'%s' is not a legal CEL identifier", (Object)qualifiers.get(0));
        qualifiers.forEach(q -> Preconditions.checkArgument((q.kind() != Qualifier.Kind.WILD_CARD ? 1 : 0) != 0, (Object)"Wildcards are not permitted in CelAttributes."));
        return new AutoValue_CelAttribute(qualifiers);
    }

    public static CelAttribute create(String rootIdentifier) {
        Preconditions.checkArgument((boolean)Qualifier.isLegalIdentifier(rootIdentifier), (String)"'%s' is not a legal CEL identifier", (Object)rootIdentifier);
        return new AutoValue_CelAttribute((ImmutableList<Qualifier>)ImmutableList.of((Object)Qualifier.ofString(rootIdentifier)));
    }

    public static CelAttribute fromQualifiedIdentifier(String qualifiedIdentifier) {
        ImmutableList.Builder qualifiers = ImmutableList.builder();
        Splitter.on((String)".").split((CharSequence)qualifiedIdentifier).forEach(element -> qualifiers.add((Object)Qualifier.ofString(element)));
        return new AutoValue_CelAttribute((ImmutableList<Qualifier>)qualifiers.build());
    }

    public abstract ImmutableList<Qualifier> qualifiers();

    public CelAttribute qualify(Qualifier qualifier) {
        Preconditions.checkArgument((qualifier.kind() != Qualifier.Kind.WILD_CARD ? 1 : 0) != 0, (Object)"Wildcards are not permitted for attributes.");
        if (this.qualifiers().isEmpty()) {
            return EMPTY;
        }
        return new AutoValue_CelAttribute((ImmutableList<Qualifier>)ImmutableList.builder().addAll(this.qualifiers()).add((Object)qualifier).build());
    }

    public final String toString() {
        if (this.equals(EMPTY)) {
            return "<empty>";
        }
        Preconditions.checkState((!this.qualifiers().isEmpty() && ((Qualifier)this.qualifiers().get(0)).kind() == Qualifier.Kind.AS_STRING ? 1 : 0) != 0, (Object)"CelAttribute must have a root qualifier that is a legal identifier");
        StringBuilder cname = new StringBuilder(((Qualifier)this.qualifiers().get(0)).asString());
        for (Qualifier qualifier : this.qualifiers().subList(1, this.qualifiers().size())) {
            if (qualifier.kind() == Qualifier.Kind.AS_STRING && Qualifier.isLegalIdentifier(qualifier)) {
                cname.append(".").append(qualifier.asString());
                continue;
            }
            cname.append(qualifier.toIndexFormat());
        }
        return cname.toString();
    }

    @Immutable
    @AutoOneOf(value=Kind.class)
    public static abstract class Qualifier {
        private static final Pattern IDENT_PATTERN = Pattern.compile((String)"[A-Za-z_][A-Za-z_0-9]*");

        public static Qualifier ofString(String value) {
            return AutoOneOf_CelAttribute_Qualifier.asString(value);
        }

        public static Qualifier ofInt(long value) {
            return AutoOneOf_CelAttribute_Qualifier.asInt(value);
        }

        public static Qualifier ofUint(UnsignedLong value) {
            return AutoOneOf_CelAttribute_Qualifier.asUint(value);
        }

        public static Qualifier ofUint(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"uint qualifier must be non-negative.");
            return Qualifier.ofUint(UnsignedLong.valueOf((long)value));
        }

        public static Qualifier ofBool(boolean value) {
            return AutoOneOf_CelAttribute_Qualifier.asBool(value);
        }

        public static Qualifier ofWildCard() {
            return AutoOneOf_CelAttribute_Qualifier.wildCard();
        }

        public abstract Kind kind();

        public abstract String asString();

        public abstract Long asInt();

        public abstract UnsignedLong asUint();

        public abstract Boolean asBool();

        public abstract void wildCard();

        public static Qualifier fromGeneric(Object value) {
            if (value instanceof UnsignedLong) {
                return Qualifier.ofUint((UnsignedLong)value);
            }
            if (value instanceof Long) {
                return Qualifier.ofInt((Long)value);
            }
            if (value instanceof Boolean) {
                return Qualifier.ofBool((Boolean)value);
            }
            if (value instanceof String) {
                return Qualifier.ofString((String)value);
            }
            throw new IllegalArgumentException("Unsupported attribute qualifier kind");
        }

        public String toIndexFormat() {
            String key = "";
            switch (this.kind().ordinal()) {
                case 0: {
                    key = "'" + this.asString() + "'";
                    break;
                }
                case 1: {
                    key = this.asInt().toString();
                    break;
                }
                case 2: {
                    key = this.asUint().toString() + "u";
                    break;
                }
                case 3: {
                    key = this.asBool() != false ? "true" : "false";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported CEL attribute qualifier for index: %s", new Object[]{this.kind()}));
                }
            }
            return String.format("[%s]", key);
        }

        public static boolean isLegalIdentifier(String identifier) {
            return IDENT_PATTERN.matches(identifier);
        }

        public static boolean isLegalIdentifier(Qualifier identifier) {
            return identifier.kind() == Kind.AS_STRING && Qualifier.isLegalIdentifier(identifier.asString());
        }

        public static enum Kind {
            AS_STRING,
            AS_INT,
            AS_UINT,
            AS_BOOL,
            WILD_CARD;

        }
    }
}

