/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import dev.cel.runtime.AutoValue_CelAttributePattern;
import dev.cel.runtime.CelAttribute;

@Immutable
@AutoValue
public abstract class CelAttributePattern {
    public static CelAttributePattern create(ImmutableList<CelAttribute.Qualifier> qualifiers) {
        Preconditions.checkArgument((!qualifiers.isEmpty() ? 1 : 0) != 0, (Object)"qualifiers must be non-empty");
        Preconditions.checkArgument((boolean)CelAttribute.Qualifier.isLegalIdentifier((CelAttribute.Qualifier)qualifiers.get(0)), (String)"'%s' is not a legal CEL identifier", (Object)qualifiers.get(0));
        return new AutoValue_CelAttributePattern(qualifiers);
    }

    public static CelAttributePattern create(String rootIdentifier) {
        Preconditions.checkArgument((boolean)CelAttribute.Qualifier.isLegalIdentifier(rootIdentifier), (String)"'%s' is not a legal CEL identifier", (Object)rootIdentifier);
        return new AutoValue_CelAttributePattern((ImmutableList<CelAttribute.Qualifier>)ImmutableList.of((Object)CelAttribute.Qualifier.ofString(rootIdentifier)));
    }

    public static CelAttributePattern fromQualifiedIdentifier(String qualifiedIdentifier) {
        ImmutableList.Builder qualifiers = ImmutableList.builder();
        Splitter.on((String)".").split((CharSequence)qualifiedIdentifier).forEach(element -> qualifiers.add((Object)CelAttribute.Qualifier.ofString(element)));
        return new AutoValue_CelAttributePattern((ImmutableList<CelAttribute.Qualifier>)qualifiers.build());
    }

    public abstract ImmutableList<CelAttribute.Qualifier> qualifiers();

    public CelAttributePattern qualify(CelAttribute.Qualifier qualifier) {
        return new AutoValue_CelAttributePattern((ImmutableList<CelAttribute.Qualifier>)ImmutableList.builder().addAll(this.qualifiers()).add((Object)qualifier).build());
    }

    public final String toString() {
        Preconditions.checkState((!this.qualifiers().isEmpty() && ((CelAttribute.Qualifier)this.qualifiers().get(0)).kind() == CelAttribute.Qualifier.Kind.AS_STRING ? 1 : 0) != 0, (Object)"CelAttribute must have a root qualifier that is a legal identifier");
        StringBuilder cname = new StringBuilder(((CelAttribute.Qualifier)this.qualifiers().get(0)).asString());
        block4: for (CelAttribute.Qualifier qualifier : this.qualifiers().subList(1, this.qualifiers().size())) {
            switch (qualifier.kind()) {
                case WILD_CARD: {
                    cname.append(".*");
                    continue block4;
                }
                case AS_STRING: {
                    if (CelAttribute.Qualifier.isLegalIdentifier(qualifier)) {
                        cname.append(".").append(qualifier.asString());
                        continue block4;
                    }
                    cname.append(qualifier.toIndexFormat());
                    continue block4;
                }
            }
            cname.append(qualifier.toIndexFormat());
        }
        return cname.toString();
    }

    public boolean isMatch(CelAttribute attribute) {
        int i;
        if (attribute.equals(CelAttribute.EMPTY)) {
            return false;
        }
        int qualifierCount = Math.min(this.qualifiers().size(), attribute.qualifiers().size());
        for (i = 0; i < qualifierCount; ++i) {
            CelAttribute.Qualifier pattern = (CelAttribute.Qualifier)this.qualifiers().get(i);
            CelAttribute.Qualifier qualifier = (CelAttribute.Qualifier)attribute.qualifiers().get(i);
            if (pattern.kind() == CelAttribute.Qualifier.Kind.WILD_CARD || pattern.equals(qualifier)) continue;
            return false;
        }
        return i >= this.qualifiers().size();
    }

    public boolean isPartialMatch(CelAttribute attribute) {
        if (attribute.equals(CelAttribute.EMPTY)) {
            return false;
        }
        int qualifierCount = Math.min(this.qualifiers().size(), attribute.qualifiers().size());
        for (int i = 0; i < qualifierCount; ++i) {
            CelAttribute.Qualifier pattern = (CelAttribute.Qualifier)this.qualifiers().get(i);
            CelAttribute.Qualifier qualifier = (CelAttribute.Qualifier)attribute.qualifiers().get(i);
            if (pattern.kind() == CelAttribute.Qualifier.Kind.WILD_CARD || pattern.equals(qualifier)) continue;
            return false;
        }
        return true;
    }

    public CelAttribute simplify(CelAttribute candidate) {
        int patternLen = this.qualifiers().size();
        if (patternLen < candidate.qualifiers().size()) {
            return CelAttribute.create((ImmutableList<CelAttribute.Qualifier>)candidate.qualifiers().subList(0, patternLen));
        }
        return candidate;
    }
}

