/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Message;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelOptions;
import dev.cel.runtime.Activation;
import dev.cel.runtime.AutoValue_CelRuntime_CelFunctionBinding;
import dev.cel.runtime.AutoValue_CelRuntime_Program;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelEvaluationListener;
import dev.cel.runtime.CelFunctionOverload;
import dev.cel.runtime.CelVariableResolver;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.Interpretable;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.RuntimeUnknownResolver;
import dev.cel.runtime.UnknownContext;
import dev.cel.runtime.UnknownTrackingInterpretable;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface CelRuntime {
    @CanIgnoreReturnValue
    public Program createProgram(CelAbstractSyntaxTree var1) throws CelEvaluationException;

    @Immutable
    @AutoValue
    public static abstract class CelFunctionBinding {
        public abstract String getOverloadId();

        abstract ImmutableList<Class<?>> getArgTypes();

        abstract CelFunctionOverload getDefinition();

        public static <T> CelFunctionBinding from(String overloadId, Class<T> arg, CelFunctionOverload.Unary<T> impl) {
            return new AutoValue_CelRuntime_CelFunctionBinding(overloadId, ImmutableList.of(arg), args -> impl.apply(args[0]));
        }

        public static <T1, T2> CelFunctionBinding from(String overloadId, Class<T1> arg1, Class<T2> arg2, CelFunctionOverload.Binary<T1, T2> impl) {
            return new AutoValue_CelRuntime_CelFunctionBinding(overloadId, ImmutableList.of(arg1, arg2), args -> impl.apply(args[0], args[1]));
        }

        public static CelFunctionBinding from(String overloadId, Iterable<Class<?>> argTypes, CelFunctionOverload impl) {
            return new AutoValue_CelRuntime_CelFunctionBinding(overloadId, ImmutableList.copyOf(argTypes), impl);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Program {
        public Object eval() throws CelEvaluationException {
            return this.evalInternal(Activation.EMPTY);
        }

        public Object eval(Map<String, ?> mapValue) throws CelEvaluationException {
            return this.evalInternal(Activation.copyOf(mapValue));
        }

        public Object eval(Message message) throws CelEvaluationException {
            return this.evalInternal(Activation.fromProto(message, this.getOptions()));
        }

        public Object eval(CelVariableResolver resolver) throws CelEvaluationException {
            return this.evalInternal(name -> resolver.find(name).orElse(null));
        }

        public Object trace(CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalInternal(Activation.EMPTY, listener);
        }

        public Object trace(Map<String, ?> mapValue, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalInternal(Activation.copyOf(mapValue), listener);
        }

        public Object trace(Message message, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalInternal(Activation.fromProto(message, this.getOptions()), listener);
        }

        public Object trace(CelVariableResolver resolver, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalInternal((String name) -> resolver.find(name).orElse(null), listener);
        }

        public Object advanceEvaluation(UnknownContext context) throws CelEvaluationException {
            return this.evalInternal(context, CelEvaluationListener.noOpListener());
        }

        private Object evalInternal(GlobalResolver resolver) throws CelEvaluationException {
            return this.evalInternal(resolver, CelEvaluationListener.noOpListener());
        }

        private Object evalInternal(GlobalResolver resolver, CelEvaluationListener listener) throws CelEvaluationException {
            return this.evalInternal(UnknownContext.create(resolver), listener);
        }

        private Object evalInternal(UnknownContext context, CelEvaluationListener listener) throws CelEvaluationException {
            try {
                Interpretable impl = this.getInterpretable();
                if (this.getOptions().enableUnknownTracking()) {
                    Preconditions.checkState((boolean)(impl instanceof UnknownTrackingInterpretable), (Object)"Environment misconfigured. Requested unknown tracking without a compatible implementation.");
                    UnknownTrackingInterpretable interpreter = (UnknownTrackingInterpretable)((Object)impl);
                    return interpreter.evalTrackingUnknowns(RuntimeUnknownResolver.builder().setResolver(context.variableResolver()).setAttributeResolver(context.createAttributeResolver()).build(), listener);
                }
                return impl.eval(context.variableResolver(), listener);
            }
            catch (InterpreterException e) {
                throw Program.unwrapOrCreateEvaluationException(e);
            }
        }

        abstract Interpretable getInterpretable();

        abstract CelOptions getOptions();

        static Program from(Interpretable interpretable, CelOptions options) {
            return new AutoValue_CelRuntime_Program(interpretable, options);
        }

        @CheckReturnValue
        private static CelEvaluationException unwrapOrCreateEvaluationException(InterpreterException e) {
            if (e.getCause() instanceof CelEvaluationException) {
                return (CelEvaluationException)e.getCause();
            }
            return new CelEvaluationException(e, e.getErrorCode());
        }
    }
}

