/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelDescriptorUtil;
import dev.cel.common.CelDescriptors;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.CombinedDescriptorPool;
import dev.cel.common.internal.DefaultDescriptorPool;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoMessageFactory;
import dev.cel.common.types.CelTypes;
import dev.cel.common.values.CelValueProvider;
import dev.cel.common.values.ProtoMessageValueProvider;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelRuntime;
import dev.cel.runtime.CelRuntimeBuilder;
import dev.cel.runtime.CelRuntimeLibrary;
import dev.cel.runtime.DefaultDispatcher;
import dev.cel.runtime.DefaultInterpreter;
import dev.cel.runtime.DescriptorMessageProvider;
import dev.cel.runtime.Interpreter;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.RuntimeTypeProvider;
import dev.cel.runtime.RuntimeTypeProviderLegacyImpl;
import dev.cel.runtime.StandardFunctions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.jspecify.nullness.Nullable;

@ThreadSafe
@Internal
public final class CelRuntimeLegacyImpl
implements CelRuntime {
    private final Interpreter interpreter;
    private final CelOptions options;

    @Override
    public CelRuntime.Program createProgram(CelAbstractSyntaxTree ast) {
        Preconditions.checkState((boolean)ast.isChecked(), (Object)"programs must be created from checked expressions");
        return CelRuntime.Program.from(this.interpreter.createInterpretable(ast), this.options);
    }

    public static CelRuntimeBuilder newBuilder() {
        return new Builder();
    }

    private CelRuntimeLegacyImpl(Interpreter interpreter, CelOptions options) {
        this.interpreter = interpreter;
        this.options = options;
    }

    public static final class Builder
    implements CelRuntimeBuilder {
        private final ImmutableSet.Builder<Descriptors.FileDescriptor> fileTypes;
        private final ImmutableMap.Builder<String, CelRuntime.CelFunctionBinding> functionBindings;
        private final ImmutableSet.Builder<CelRuntimeLibrary> celRuntimeLibraries;
        private CelOptions options = CelOptions.newBuilder().build();
        private boolean standardEnvironmentEnabled;
        private Function<String, Message.Builder> customTypeFactory = null;
        private ExtensionRegistry extensionRegistry;
        private CelValueProvider celValueProvider;

        @Override
        public CelRuntimeBuilder setOptions(CelOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public CelRuntimeBuilder addFunctionBindings(CelRuntime.CelFunctionBinding ... bindings) {
            return this.addFunctionBindings(Arrays.asList(bindings));
        }

        @Override
        public CelRuntimeBuilder addFunctionBindings(Iterable<CelRuntime.CelFunctionBinding> bindings) {
            bindings.forEach(o -> this.functionBindings.put((Object)o.getOverloadId(), o));
            return this;
        }

        @Override
        public CelRuntimeBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            return this.addMessageTypes(Arrays.asList(descriptors));
        }

        @Override
        public CelRuntimeBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            return this.addFileTypes((Iterable<Descriptors.FileDescriptor>)CelDescriptorUtil.getFileDescriptorsForDescriptors(descriptors));
        }

        @Override
        public CelRuntimeBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            return this.addFileTypes(Arrays.asList(fileDescriptors));
        }

        @Override
        public CelRuntimeBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.fileTypes.addAll((Iterable)Preconditions.checkNotNull(fileDescriptors));
            return this;
        }

        @Override
        public CelRuntimeBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            return this.addFileTypes((Iterable<Descriptors.FileDescriptor>)CelDescriptorUtil.getFileDescriptorsFromFileDescriptorSet(fileDescriptorSet));
        }

        @Override
        public CelRuntimeBuilder setTypeFactory(Function<String, Message.Builder> typeFactory) {
            this.customTypeFactory = typeFactory;
            return this;
        }

        @Override
        public CelRuntimeBuilder setValueProvider(CelValueProvider celValueProvider) {
            this.celValueProvider = celValueProvider;
            return this;
        }

        @Override
        public CelRuntimeBuilder setStandardEnvironmentEnabled(boolean value) {
            this.standardEnvironmentEnabled = value;
            return this;
        }

        @Override
        public CelRuntimeBuilder addLibraries(CelRuntimeLibrary ... libraries) {
            Preconditions.checkNotNull((Object)libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelRuntimeBuilder addLibraries(Iterable<? extends CelRuntimeLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.celRuntimeLibraries.addAll(libraries);
            return this;
        }

        @Override
        public CelRuntimeBuilder setExtensionRegistry(ExtensionRegistry extensionRegistry) {
            Preconditions.checkNotNull((Object)extensionRegistry);
            this.extensionRegistry = extensionRegistry.getUnmodifiable();
            return this;
        }

        @Override
        public CelRuntimeLegacyImpl build() {
            RuntimeTypeProvider runtimeTypeProvider;
            this.celRuntimeLibraries.build().forEach(celLibrary -> celLibrary.setRuntimeOptions(this));
            CelDescriptors celDescriptors = CelDescriptorUtil.getAllDescriptorsFromFileDescriptor((Iterable<Descriptors.FileDescriptor>)this.fileTypes.build(), this.options.resolveTypeDependencies());
            CelDescriptorPool celDescriptorPool = Builder.newDescriptorPool(celDescriptors, this.extensionRegistry);
            ProtoMessageFactory runtimeTypeFactory = this.customTypeFactory != null ? messageName -> CelTypes.isWellKnownType(messageName) ? Optional.empty() : Optional.ofNullable(this.customTypeFactory.apply(messageName)) : null;
            runtimeTypeFactory = Builder.maybeCombineMessageFactory(runtimeTypeFactory, DefaultMessageFactory.create(celDescriptorPool));
            DynamicProto dynamicProto = DynamicProto.create(runtimeTypeFactory);
            DefaultDispatcher dispatcher = DefaultDispatcher.create(this.options, dynamicProto);
            if (this.standardEnvironmentEnabled) {
                StandardFunctions.add(dispatcher, dynamicProto, this.options);
            }
            ImmutableMap functionBindingMap = this.functionBindings.buildOrThrow();
            functionBindingMap.forEach((overloadId, func) -> dispatcher.add((String)overloadId, (List<Class<?>>)func.getArgTypes(), args -> {
                try {
                    return func.getDefinition().apply(args);
                }
                catch (CelEvaluationException e) {
                    throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(e.getErrorCode()).build();
                }
            }));
            if (this.options.enableCelValue()) {
                CelValueProvider messageValueProvider = ProtoMessageValueProvider.newInstance(dynamicProto, this.options);
                if (this.celValueProvider != null) {
                    messageValueProvider = new CelValueProvider.CombinedCelValueProvider(this.celValueProvider, messageValueProvider);
                }
                runtimeTypeProvider = new RuntimeTypeProviderLegacyImpl(this.options, messageValueProvider, celDescriptorPool, dynamicProto);
            } else {
                runtimeTypeProvider = new DescriptorMessageProvider(runtimeTypeFactory, this.options);
            }
            return new CelRuntimeLegacyImpl(new DefaultInterpreter(runtimeTypeProvider, dispatcher, this.options), this.options);
        }

        private static CelDescriptorPool newDescriptorPool(CelDescriptors celDescriptors, ExtensionRegistry extensionRegistry) {
            ImmutableList.Builder descriptorPools = new ImmutableList.Builder();
            descriptorPools.add((Object)DefaultDescriptorPool.create(celDescriptors, extensionRegistry));
            return CombinedDescriptorPool.create((ImmutableList<CelDescriptorPool>)descriptorPools.build());
        }

        @CanIgnoreReturnValue
        private static ProtoMessageFactory maybeCombineMessageFactory(@Nullable ProtoMessageFactory parentFactory, ProtoMessageFactory childFactory) {
            if (parentFactory == null) {
                return childFactory;
            }
            return new ProtoMessageFactory.CombinedMessageFactory((Iterable<ProtoMessageFactory>)ImmutableList.of((Object)parentFactory, (Object)childFactory));
        }

        private Builder() {
            this.fileTypes = ImmutableSet.builder();
            this.functionBindings = ImmutableMap.builder();
            this.celRuntimeLibraries = ImmutableSet.builder();
            this.extensionRegistry = ExtensionRegistry.getEmptyRegistry();
        }
    }
}

