/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.MessageLite;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.ExprFeatures;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.runtime.Dispatcher;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.Metadata;
import dev.cel.runtime.Registrar;
import dev.cel.runtime.StandardFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Internal
public final class DefaultDispatcher
implements Dispatcher,
Registrar {
    private final CelOptions celOptions;
    @GuardedBy(value="this")
    private final Map<String, Overload> overloads = new HashMap<String, Overload>();

    @Deprecated
    public DefaultDispatcher(ImmutableSet<ExprFeatures> features) {
        this(CelOptions.fromExprFeatures(features));
    }

    public DefaultDispatcher(CelOptions celOptions) {
        this.celOptions = celOptions;
    }

    @Deprecated
    public static DefaultDispatcher create(ImmutableSet<ExprFeatures> features) {
        return DefaultDispatcher.create(CelOptions.fromExprFeatures(features));
    }

    public static DefaultDispatcher create(CelOptions celOptions) {
        DynamicProto dynamicProto = DynamicProto.create(DefaultMessageFactory.INSTANCE);
        return DefaultDispatcher.create(celOptions, dynamicProto);
    }

    public static DefaultDispatcher create(CelOptions celOptions, DynamicProto dynamicProto) {
        DefaultDispatcher dispatcher = new DefaultDispatcher(celOptions);
        StandardFunctions.add(dispatcher, dynamicProto, celOptions);
        return dispatcher;
    }

    public static DefaultDispatcher create() {
        return DefaultDispatcher.create(CelOptions.LEGACY);
    }

    @Override
    public synchronized <T> void add(String overloadId, Class<T> argType, Registrar.UnaryFunction<T> function) {
        this.overloads.put(overloadId, new Overload(new Class[]{argType}, args -> function.apply(args[0])));
    }

    @Override
    public synchronized <T1, T2> void add(String overloadId, Class<T1> argType1, Class<T2> argType2, Registrar.BinaryFunction<T1, T2> function) {
        this.overloads.put(overloadId, new Overload(new Class[]{argType1, argType2}, args -> function.apply(args[0], args[1])));
    }

    @Override
    public synchronized void add(String overloadId, List<Class<?>> argTypes, Registrar.Function function) {
        this.overloads.put(overloadId, new Overload(argTypes.toArray(new Class[0]), function));
    }

    private static Object dispatch(Metadata metadata, long exprId, String functionName, List<String> overloadIds, Map<String, Overload> overloads, Object[] args) throws InterpreterException {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String overloadId : overloadIds) {
            Overload overload = overloads.get(overloadId);
            if (overload == null) {
                throw new InterpreterException.Builder("[internal] Unknown overload id '%s' for function '%s'", overloadId, functionName).setErrorCode(CelErrorCode.OVERLOAD_NOT_FOUND).setLocation(metadata, exprId).build();
            }
            if (!overload.canHandle(args)) continue;
            candidates.add(overloadId);
        }
        if (candidates.size() == 1) {
            String overloadId = (String)candidates.get(0);
            try {
                return overloads.get((Object)overloadId).function.apply(args);
            }
            catch (RuntimeException e) {
                throw new InterpreterException.Builder(e, "Function '%s' failed with arg(s) '%s'", overloadId, Joiner.on((String)", ").join(args)).build();
            }
        }
        if (candidates.size() > 1) {
            throw new InterpreterException.Builder("Ambiguous overloads for function '%s'. Matching candidates: %s", functionName, Joiner.on((String)",").join(candidates)).setErrorCode(CelErrorCode.AMBIGUOUS_OVERLOAD).setLocation(metadata, exprId).build();
        }
        throw new InterpreterException.Builder("No matching overload for function '%s'. Overload candidates: %s", functionName, Joiner.on((String)",").join(overloadIds)).setErrorCode(CelErrorCode.OVERLOAD_NOT_FOUND).setLocation(metadata, exprId).build();
    }

    @Override
    public synchronized Object dispatch(Metadata metadata, long exprId, String functionName, List<String> overloadIds, Object[] args) throws InterpreterException {
        return DefaultDispatcher.dispatch(metadata, exprId, functionName, overloadIds, this.overloads, args);
    }

    @Override
    public synchronized Dispatcher.ImmutableCopy immutableCopy() {
        return new ImmutableCopy(this.overloads);
    }

    @Immutable
    private static final class Overload {
        final ImmutableList<Class<?>> parameterTypes;
        final Registrar.Function function;

        private Overload(Class<?>[] parameterTypes, Registrar.Function function) {
            this.parameterTypes = ImmutableList.copyOf((Object[])parameterTypes);
            this.function = function;
        }

        private boolean canHandle(Object[] arguments) {
            if (this.parameterTypes.size() != arguments.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                Class paramType = (Class)this.parameterTypes.get(i);
                Object arg = arguments[i];
                if (!(arg == null ? paramType != Object.class && !MessageLite.class.isAssignableFrom(paramType) && !Map.class.isAssignableFrom(paramType) : !paramType.isAssignableFrom(arg.getClass()))) continue;
                return false;
            }
            return true;
        }
    }

    @Immutable
    private static final class ImmutableCopy
    implements Dispatcher.ImmutableCopy {
        private final ImmutableMap<String, Overload> overloads;

        private ImmutableCopy(Map<String, Overload> overloads) {
            this.overloads = ImmutableMap.copyOf(overloads);
        }

        @Override
        public Object dispatch(Metadata metadata, long exprId, String functionName, List<String> overloadIds, Object[] args) throws InterpreterException {
            return DefaultDispatcher.dispatch(metadata, exprId, functionName, overloadIds, this.overloads, args);
        }

        @Override
        public Dispatcher.ImmutableCopy immutableCopy() {
            return this;
        }
    }
}

