/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelProtoAbstractSyntaxTree;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.expr.CheckedExpr;
import dev.cel.expr.Value;
import dev.cel.runtime.AutoValue_DefaultInterpreter_IntermediateResult;
import dev.cel.runtime.CallArgumentChecker;
import dev.cel.runtime.CelAttribute;
import dev.cel.runtime.CelEvaluationListener;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.DefaultMetadata;
import dev.cel.runtime.Dispatcher;
import dev.cel.runtime.GlobalResolver;
import dev.cel.runtime.Interpretable;
import dev.cel.runtime.Interpreter;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.InterpreterUtil;
import dev.cel.runtime.Metadata;
import dev.cel.runtime.RuntimeHelpers;
import dev.cel.runtime.RuntimeTypeProvider;
import dev.cel.runtime.RuntimeUnknownResolver;
import dev.cel.runtime.UnknownTrackingInterpretable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Internal
public final class DefaultInterpreter
implements Interpreter {
    private final RuntimeTypeProvider typeProvider;
    private final Dispatcher dispatcher;
    private final CelOptions celOptions;

    public DefaultInterpreter(RuntimeTypeProvider typeProvider, Dispatcher dispatcher) {
        this(typeProvider, dispatcher, CelOptions.LEGACY);
    }

    public DefaultInterpreter(RuntimeTypeProvider typeProvider, Dispatcher dispatcher, CelOptions celOptions) {
        this.typeProvider = (RuntimeTypeProvider)Preconditions.checkNotNull((Object)typeProvider);
        this.dispatcher = (Dispatcher)Preconditions.checkNotNull((Object)dispatcher);
        this.celOptions = celOptions;
    }

    @Override
    @Deprecated
    public Interpretable createInterpretable(CheckedExpr checkedExpr) {
        return this.createInterpretable(CelProtoAbstractSyntaxTree.fromCheckedExpr(checkedExpr).getAst());
    }

    @Override
    public Interpretable createInterpretable(CelAbstractSyntaxTree ast) {
        return new DefaultInterpretable(this.typeProvider, this.dispatcher, ast, this.celOptions);
    }

    @Immutable
    private static final class DefaultInterpretable
    implements Interpretable,
    UnknownTrackingInterpretable {
        private final RuntimeTypeProvider typeProvider;
        private final Dispatcher.ImmutableCopy dispatcher;
        private final Metadata metadata;
        private final CelAbstractSyntaxTree ast;
        private final CelOptions celOptions;

        DefaultInterpretable(RuntimeTypeProvider typeProvider, Dispatcher dispatcher, CelAbstractSyntaxTree ast, CelOptions celOptions) {
            this.typeProvider = (RuntimeTypeProvider)Preconditions.checkNotNull((Object)typeProvider);
            this.dispatcher = ((Dispatcher)Preconditions.checkNotNull((Object)dispatcher)).immutableCopy();
            this.ast = (CelAbstractSyntaxTree)Preconditions.checkNotNull((Object)ast);
            this.metadata = new DefaultMetadata(ast);
            this.celOptions = (CelOptions)Preconditions.checkNotNull((Object)celOptions);
        }

        @Override
        public Object eval(GlobalResolver resolver) throws InterpreterException {
            return this.eval(resolver, CelEvaluationListener.noOpListener());
        }

        @Override
        public Object eval(GlobalResolver resolver, CelEvaluationListener listener) throws InterpreterException {
            return this.evalTrackingUnknowns(RuntimeUnknownResolver.fromResolver(resolver), listener);
        }

        @Override
        public Object evalTrackingUnknowns(RuntimeUnknownResolver resolver, CelEvaluationListener listener) throws InterpreterException {
            ExecutionFrame frame = new ExecutionFrame(listener, resolver, this.celOptions.comprehensionMaxIterations());
            IntermediateResult internalResult = this.evalInternal(frame, this.ast.getExpr());
            Object result = internalResult.value();
            return InterpreterUtil.completeDataOnly(result, "Incomplete data cannot be returned as a result.");
        }

        private IntermediateResult evalInternal(ExecutionFrame frame, CelExpr expr) throws InterpreterException {
            try {
                IntermediateResult result;
                CelExpr.ExprKind.Kind exprKind = expr.exprKind().getKind();
                switch (exprKind) {
                    case CONSTANT: {
                        result = IntermediateResult.create(this.evalConstant(frame, expr, expr.constant()));
                        break;
                    }
                    case IDENT: {
                        result = this.evalIdent(frame, expr, expr.ident());
                        break;
                    }
                    case SELECT: {
                        result = this.evalSelect(frame, expr, expr.select());
                        break;
                    }
                    case CALL: {
                        result = this.evalCall(frame, expr, expr.call());
                        break;
                    }
                    case CREATE_LIST: {
                        result = this.evalList(frame, expr, expr.createList());
                        break;
                    }
                    case CREATE_STRUCT: {
                        result = this.evalStruct(frame, expr, expr.createStruct());
                        break;
                    }
                    case CREATE_MAP: {
                        result = this.evalMap(frame, expr.createMap());
                        break;
                    }
                    case COMPREHENSION: {
                        result = this.evalComprehension(frame, expr, expr.comprehension());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected expression kind: " + (Object)((Object)expr.exprKind().getKind()));
                    }
                }
                frame.getEvaluationListener().callback(expr, result.value());
                return result;
            }
            catch (RuntimeException e) {
                throw new InterpreterException.Builder(e, e.getMessage(), new Object[0]).setLocation(this.metadata, expr.id()).build();
            }
        }

        private boolean isUnknownValue(Object value) {
            return value instanceof CelUnknownSet || InterpreterUtil.isUnknown(value);
        }

        private Object evalConstant(ExecutionFrame unusedFrame, CelExpr unusedExpr, CelConstant constExpr) {
            switch (constExpr.getKind()) {
                case NULL_VALUE: {
                    return constExpr.nullValue();
                }
                case BOOLEAN_VALUE: {
                    return constExpr.booleanValue();
                }
                case INT64_VALUE: {
                    return constExpr.int64Value();
                }
                case UINT64_VALUE: {
                    if (this.celOptions.enableUnsignedLongs()) {
                        return constExpr.uint64Value();
                    }
                    return constExpr.uint64Value().longValue();
                }
                case DOUBLE_VALUE: {
                    return constExpr.doubleValue();
                }
                case STRING_VALUE: {
                    return constExpr.stringValue();
                }
                case BYTES_VALUE: {
                    return constExpr.bytesValue();
                }
            }
            throw new IllegalStateException("unsupported constant case: " + (Object)((Object)constExpr.getKind()));
        }

        private IntermediateResult evalIdent(ExecutionFrame frame, CelExpr expr, CelExpr.CelIdent unusedIdent) throws InterpreterException {
            CelReference reference = this.ast.getReferenceOrThrow(expr.id());
            if (reference.value().isPresent()) {
                return IntermediateResult.create(this.evalConstant(frame, expr, reference.value().get()));
            }
            return this.resolveIdent(frame, expr, reference.name());
        }

        private IntermediateResult resolveIdent(ExecutionFrame frame, CelExpr expr, String name) throws InterpreterException {
            Optional<CelType> checkedType = this.ast.getType(expr.id());
            if (checkedType.isPresent() && checkedType.get().kind() == CelKind.TYPE) {
                Value typeValue = this.typeProvider.adaptType(checkedType.get());
                return IntermediateResult.create(typeValue);
            }
            IntermediateResult rawResult = frame.resolveSimpleName(name, expr.id());
            Object value = InterpreterUtil.strict(this.typeProvider.adapt(rawResult.value()));
            return IntermediateResult.create(rawResult.attribute(), value);
        }

        private IntermediateResult evalSelect(ExecutionFrame frame, CelExpr expr, CelExpr.CelSelect selectExpr) throws InterpreterException {
            Optional<CelReference> referenceOptional = this.ast.getReference(expr.id());
            if (referenceOptional.isPresent()) {
                CelReference reference = referenceOptional.get();
                if (reference.value().isPresent()) {
                    return IntermediateResult.create(this.evalConstant(frame, expr, reference.value().get()));
                }
                return this.resolveIdent(frame, expr, reference.name());
            }
            return this.evalFieldSelect(frame, expr, selectExpr.operand(), selectExpr.field(), selectExpr.testOnly());
        }

        private IntermediateResult evalFieldSelect(ExecutionFrame frame, CelExpr expr, CelExpr operandExpr, String field, boolean isTestOnly) throws InterpreterException {
            IntermediateResult operandResult = this.evalInternal(frame, operandExpr);
            Object operand = operandResult.value();
            CelAttribute attribute = operandResult.attribute().qualify(CelAttribute.Qualifier.ofString(field));
            Optional attrValue = frame.resolveAttribute(attribute);
            if (attrValue.isPresent()) {
                return IntermediateResult.create(attribute, attrValue.get());
            }
            if (this.isUnknownValue(operand)) {
                return IntermediateResult.create(attribute, operand);
            }
            if (isTestOnly) {
                return IntermediateResult.create(attribute, this.typeProvider.hasField(operand, field));
            }
            Object fieldValue = this.typeProvider.selectField(operand, field);
            return IntermediateResult.create(attribute, InterpreterUtil.valueOrUnknown(fieldValue, expr.id()));
        }

        private IntermediateResult evalCall(ExecutionFrame frame, CelExpr expr, CelExpr.CelCall callExpr) throws InterpreterException {
            CelReference reference = this.ast.getReferenceOrThrow(expr.id());
            Preconditions.checkState((!reference.overloadIds().isEmpty() ? 1 : 0) != 0);
            switch ((String)reference.overloadIds().get(0)) {
                case "identity": {
                    return this.evalInternal(frame, (CelExpr)callExpr.args().get(0));
                }
                case "conditional": {
                    return this.evalConditional(frame, callExpr);
                }
                case "logical_and": {
                    return this.evalLogicalAnd(frame, callExpr);
                }
                case "logical_or": {
                    return this.evalLogicalOr(frame, callExpr);
                }
                case "not_strictly_false": {
                    return this.evalNotStrictlyFalse(frame, callExpr);
                }
                case "type": {
                    return this.evalType(frame, callExpr);
                }
                case "optional_or_optional": {
                    return this.evalOptionalOr(frame, callExpr);
                }
                case "optional_orValue_value": {
                    return this.evalOptionalOrValue(frame, callExpr);
                }
                case "select_optional_field": {
                    Optional<IntermediateResult> result = this.maybeEvalOptionalSelectField(frame, expr, callExpr);
                    if (!result.isPresent()) break;
                    return result.get();
                }
            }
            ArrayList<CelExpr> callArgs = new ArrayList<CelExpr>();
            callExpr.target().ifPresent(callArgs::add);
            callArgs.addAll((Collection<CelExpr>)callExpr.args());
            IntermediateResult[] argResults = new IntermediateResult[callArgs.size()];
            for (int i = 0; i < argResults.length; ++i) {
                argResults[i] = this.evalInternal(frame, (CelExpr)callArgs.get(i));
                InterpreterUtil.completeDataOnly(argResults[i].value(), "Incomplete data does not support function calls.");
            }
            Optional<CelAttribute> indexAttr = this.maybeContainerIndexAttribute((String)reference.overloadIds().get(0), argResults);
            CelAttribute attr = indexAttr.orElse(CelAttribute.EMPTY);
            Optional resolved = frame.resolveAttribute(attr);
            if (resolved.isPresent()) {
                return IntermediateResult.create(attr, resolved.get());
            }
            CallArgumentChecker argChecker = indexAttr.isPresent() ? CallArgumentChecker.createAcceptingPartial(frame.getResolver()) : CallArgumentChecker.create(frame.getResolver());
            for (IntermediateResult element : argResults) {
                argChecker.checkArg(element);
            }
            Optional<Object> unknowns = argChecker.maybeUnknowns();
            if (unknowns.isPresent()) {
                return IntermediateResult.create(attr, unknowns.get());
            }
            Object[] argArray = Arrays.stream(argResults).map(v -> v.value()).toArray();
            return IntermediateResult.create(attr, this.dispatcher.dispatch(this.metadata, expr.id(), callExpr.function(), (List<String>)reference.overloadIds(), argArray));
        }

        private Optional<CelAttribute> maybeContainerIndexAttribute(String overloadId, IntermediateResult[] args) {
            switch (overloadId) {
                case "index_list": {
                    if (args.length != 2 || !(args[1].value() instanceof Long)) break;
                    return Optional.of(args[0].attribute().qualify(CelAttribute.Qualifier.ofInt((Long)args[1].value())));
                }
                case "index_map": {
                    if (args.length != 2) break;
                    try {
                        CelAttribute.Qualifier qualifier = CelAttribute.Qualifier.fromGeneric(args[1].value());
                        return Optional.of(args[0].attribute().qualify(qualifier));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
            }
            return Optional.empty();
        }

        private IntermediateResult evalConditional(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            IntermediateResult condition = this.evalBooleanStrict(frame, (CelExpr)callExpr.args().get(0));
            if (this.isUnknownValue(condition.value())) {
                return condition;
            }
            if (((Boolean)condition.value()).booleanValue()) {
                return this.evalInternal(frame, (CelExpr)callExpr.args().get(1));
            }
            return this.evalInternal(frame, (CelExpr)callExpr.args().get(2));
        }

        private IntermediateResult mergeBooleanUnknowns(IntermediateResult lhs, IntermediateResult rhs) throws InterpreterException {
            if (lhs.value() instanceof CelUnknownSet && rhs.value() instanceof CelUnknownSet) {
                return IntermediateResult.create(((CelUnknownSet)lhs.value()).merge((CelUnknownSet)rhs.value()));
            }
            if (lhs.value() instanceof CelUnknownSet) {
                return lhs;
            }
            if (rhs.value() instanceof CelUnknownSet) {
                return rhs;
            }
            return IntermediateResult.create(InterpreterUtil.shortcircuitUnknownOrThrowable(lhs.value(), rhs.value()));
        }

        private IntermediateResult evalLogicalOr(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            IntermediateResult left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
            if (left.value() instanceof Boolean && ((Boolean)left.value()).booleanValue()) {
                return left;
            }
            IntermediateResult right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
            if (right.value() instanceof Boolean && ((Boolean)right.value()).booleanValue()) {
                return right;
            }
            if (right.value() instanceof Boolean && left.value() instanceof Boolean) {
                return left;
            }
            return this.mergeBooleanUnknowns(left, right);
        }

        private IntermediateResult evalLogicalAnd(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            IntermediateResult left = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(0));
            if (left.value() instanceof Boolean && !((Boolean)left.value()).booleanValue()) {
                return left;
            }
            IntermediateResult right = this.evalBooleanNonstrict(frame, (CelExpr)callExpr.args().get(1));
            if (right.value() instanceof Boolean && !((Boolean)right.value()).booleanValue()) {
                return right;
            }
            if (right.value() instanceof Boolean && left.value() instanceof Boolean) {
                return left;
            }
            return this.mergeBooleanUnknowns(left, right);
        }

        private IntermediateResult evalNotStrictlyFalse(ExecutionFrame frame, CelExpr.CelCall callExpr) {
            try {
                IntermediateResult value = this.evalBooleanStrict(frame, (CelExpr)callExpr.args().get(0));
                if (value.value() instanceof Boolean) {
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return IntermediateResult.create(true);
        }

        private IntermediateResult evalType(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            CelExpr typeExprArg = (CelExpr)callExpr.args().get(0);
            IntermediateResult argResult = this.evalInternal(frame, typeExprArg);
            CelType checkedType = this.ast.getType(typeExprArg.id()).orElseThrow(() -> new InterpreterException.Builder("expected a runtime type for '%s' from checked expression, but found none.", argResult.getClass().getSimpleName()).setErrorCode(CelErrorCode.TYPE_NOT_FOUND).setLocation(this.metadata, typeExprArg.id()).build());
            Value checkedTypeValue = this.typeProvider.adaptType(checkedType);
            Value typeValue = this.typeProvider.resolveObjectType(argResult.value(), checkedTypeValue);
            return IntermediateResult.create(typeValue);
        }

        private IntermediateResult evalOptionalOr(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            CelExpr lhsExpr = callExpr.target().get();
            IntermediateResult lhsResult = this.evalInternal(frame, lhsExpr);
            if (!(lhsResult.value() instanceof Optional)) {
                throw new InterpreterException.Builder("expected optional value, found: %s", lhsResult.value()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setLocation(this.metadata, lhsExpr.id()).build();
            }
            Optional lhsOptionalValue = (Optional)lhsResult.value();
            if (lhsOptionalValue.isPresent()) {
                return lhsResult;
            }
            return this.evalInternal(frame, (CelExpr)callExpr.args().get(0));
        }

        private IntermediateResult evalOptionalOrValue(ExecutionFrame frame, CelExpr.CelCall callExpr) throws InterpreterException {
            CelExpr lhsExpr = callExpr.target().get();
            IntermediateResult lhsResult = this.evalInternal(frame, lhsExpr);
            if (!(lhsResult.value() instanceof Optional)) {
                throw new InterpreterException.Builder("expected optional value, found: %s", lhsResult.value()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setLocation(this.metadata, lhsExpr.id()).build();
            }
            Optional lhsOptionalValue = (Optional)lhsResult.value();
            if (lhsOptionalValue.isPresent()) {
                return IntermediateResult.create(lhsOptionalValue.get());
            }
            return this.evalInternal(frame, (CelExpr)callExpr.args().get(0));
        }

        private Optional<IntermediateResult> maybeEvalOptionalSelectField(ExecutionFrame frame, CelExpr expr, CelExpr.CelCall callExpr) throws InterpreterException {
            CelExpr operand = (CelExpr)callExpr.args().get(0);
            IntermediateResult lhsResult = this.evalInternal(frame, operand);
            if (lhsResult.value() instanceof Map) {
                return Optional.empty();
            }
            String field = ((CelExpr)callExpr.args().get(1)).constant().stringValue();
            boolean hasField = (Boolean)this.typeProvider.hasField(lhsResult.value(), field);
            if (!hasField) {
                return Optional.of(IntermediateResult.create(Optional.empty()));
            }
            IntermediateResult result = this.evalFieldSelect(frame, expr, operand, field, false);
            return Optional.of(IntermediateResult.create(result.attribute(), Optional.of(result.value())));
        }

        private IntermediateResult evalBoolean(ExecutionFrame frame, CelExpr expr, boolean strict) throws InterpreterException {
            IntermediateResult value;
            IntermediateResult intermediateResult = value = strict ? this.evalInternal(frame, expr) : this.evalNonstrictly(frame, expr);
            if (!(value.value() instanceof Boolean || this.isUnknownValue(value.value()) || value.value() instanceof Exception)) {
                throw new InterpreterException.Builder("expected boolean value, found: %s", value.value()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setLocation(this.metadata, expr.id()).build();
            }
            return value;
        }

        private IntermediateResult evalBooleanStrict(ExecutionFrame frame, CelExpr expr) throws InterpreterException {
            return this.evalBoolean(frame, expr, true);
        }

        private IntermediateResult evalBooleanNonstrict(ExecutionFrame frame, CelExpr expr) throws InterpreterException {
            return this.evalBoolean(frame, expr, false);
        }

        private IntermediateResult evalList(ExecutionFrame frame, CelExpr unusedExpr, CelExpr.CelCreateList listExpr) throws InterpreterException {
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            ArrayList<Object> result = new ArrayList<Object>(listExpr.elements().size());
            HashSet<Integer> optionalIndicesSet = new HashSet<Integer>((Collection<Integer>)listExpr.optionalIndices());
            ImmutableList<CelExpr> elements = listExpr.elements();
            for (int i = 0; i < elements.size(); ++i) {
                CelExpr element = (CelExpr)elements.get(i);
                IntermediateResult evaluatedElement = this.evalInternal(frame, element);
                InterpreterUtil.completeDataOnly(evaluatedElement.value(), "Incomplete data cannot be an elem of a list.");
                argChecker.checkArg(evaluatedElement);
                Object value = evaluatedElement.value();
                if (optionalIndicesSet.contains(i)) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) continue;
                    value = optionalVal.get();
                }
                result.add(value);
            }
            return IntermediateResult.create(argChecker.maybeUnknowns().orElse(result));
        }

        private IntermediateResult evalMap(ExecutionFrame frame, CelExpr.CelCreateMap mapExpr) throws InterpreterException {
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (CelExpr.CelCreateMap.Entry entry : mapExpr.entries()) {
                IntermediateResult keyResult = this.evalInternal(frame, entry.key());
                argChecker.checkArg(keyResult);
                IntermediateResult valueResult = this.evalInternal(frame, entry.value());
                InterpreterUtil.completeDataOnly(valueResult.value(), "Incomplete data cannot be a value of a map.");
                argChecker.checkArg(valueResult);
                if (this.celOptions.errorOnDuplicateMapKeys() && result.containsKey(keyResult.value())) {
                    throw new InterpreterException.Builder("duplicate map key [%s]", keyResult.value()).setErrorCode(CelErrorCode.DUPLICATE_ATTRIBUTE).setLocation(this.metadata, entry.id()).build();
                }
                Object value = valueResult.value();
                if (entry.optionalEntry()) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) {
                        result.remove(keyResult.value());
                        continue;
                    }
                    value = optionalVal.get();
                }
                result.put(keyResult.value(), value);
            }
            return IntermediateResult.create(argChecker.maybeUnknowns().orElse(result));
        }

        private IntermediateResult evalStruct(ExecutionFrame frame, CelExpr expr, CelExpr.CelCreateStruct structExpr) throws InterpreterException {
            CelReference reference = this.ast.getReference(expr.id()).orElseThrow(() -> new IllegalStateException("Could not find a reference for CelCreateStruct expresison at ID: " + expr.id()));
            CallArgumentChecker argChecker = CallArgumentChecker.create(frame.getResolver());
            HashMap<String, Object> fields = new HashMap<String, Object>();
            for (CelExpr.CelCreateStruct.Entry entry : structExpr.entries()) {
                IntermediateResult fieldResult = this.evalInternal(frame, entry.value());
                InterpreterUtil.completeDataOnly(fieldResult.value(), "Incomplete data cannot be a field of a message.");
                argChecker.checkArg(fieldResult);
                Object value = fieldResult.value();
                if (entry.optionalEntry()) {
                    Optional optionalVal = (Optional)value;
                    if (!optionalVal.isPresent()) {
                        fields.remove(entry.fieldKey());
                        continue;
                    }
                    value = optionalVal.get();
                }
                fields.put(entry.fieldKey(), value);
            }
            Optional<Object> unknowns = argChecker.maybeUnknowns();
            if (unknowns.isPresent()) {
                return IntermediateResult.create(unknowns.get());
            }
            return IntermediateResult.create(this.typeProvider.createMessage(reference.name(), fields));
        }

        private IntermediateResult evalNonstrictly(ExecutionFrame frame, CelExpr expr) {
            try {
                return this.evalInternal(frame, expr);
            }
            catch (Exception e) {
                return IntermediateResult.create(e);
            }
        }

        private IntermediateResult evalComprehension(ExecutionFrame frame, CelExpr unusedExpr, CelExpr.CelComprehension compre) throws InterpreterException {
            Collection<Object> iterRange;
            String accuVar = compre.accuVar();
            String iterVar = compre.iterVar();
            IntermediateResult iterRangeRaw = this.evalInternal(frame, compre.iterRange());
            if (this.isUnknownValue(iterRangeRaw.value())) {
                return iterRangeRaw;
            }
            if (iterRangeRaw.value() instanceof List) {
                iterRange = (List)iterRangeRaw.value();
            } else if (iterRangeRaw.value() instanceof Map) {
                iterRange = ((Map)iterRangeRaw.value()).keySet();
            } else {
                throw new InterpreterException.Builder("expected a list or a map for iteration range but got '%s'", iterRangeRaw.value().getClass().getSimpleName()).setErrorCode(CelErrorCode.INVALID_ARGUMENT).setLocation(this.metadata, compre.iterRange().id()).build();
            }
            IntermediateResult accuValue = this.evalNonstrictly(frame, compre.accuInit());
            int i = 0;
            for (Object elem : iterRange) {
                frame.incrementIterations();
                CelAttribute iterAttr = CelAttribute.EMPTY;
                if (iterRange instanceof List) {
                    iterAttr = iterRangeRaw.attribute().qualify(CelAttribute.Qualifier.ofInt(i));
                }
                ++i;
                ImmutableMap loopVars = ImmutableMap.of((Object)iterVar, (Object)IntermediateResult.create(iterAttr, RuntimeHelpers.maybeAdaptPrimitive(elem)), (Object)accuVar, (Object)accuValue);
                frame.pushScope((ImmutableMap<String, IntermediateResult>)loopVars);
                IntermediateResult evalObject = this.evalBooleanStrict(frame, compre.loopCondition());
                if (!this.isUnknownValue(evalObject.value()) && !((Boolean)evalObject.value()).booleanValue()) {
                    frame.popScope();
                    break;
                }
                accuValue = this.evalNonstrictly(frame, compre.loopStep());
                frame.popScope();
            }
            frame.pushScope((ImmutableMap<String, IntermediateResult>)ImmutableMap.of((Object)accuVar, (Object)accuValue));
            IntermediateResult result = this.evalInternal(frame, compre.result());
            frame.popScope();
            return result;
        }
    }

    private static class ExecutionFrame {
        private final CelEvaluationListener evaluationListener;
        private final int maxIterations;
        private final ArrayDeque<RuntimeUnknownResolver> resolvers;
        private RuntimeUnknownResolver currentResolver;
        private int iterations;

        private ExecutionFrame(CelEvaluationListener evaluationListener, RuntimeUnknownResolver resolver, int maxIterations) {
            this.evaluationListener = evaluationListener;
            this.resolvers = new ArrayDeque();
            this.resolvers.add(resolver);
            this.currentResolver = resolver;
            this.maxIterations = maxIterations;
        }

        private CelEvaluationListener getEvaluationListener() {
            return this.evaluationListener;
        }

        private RuntimeUnknownResolver getResolver() {
            return this.currentResolver;
        }

        private void incrementIterations() throws InterpreterException {
            if (this.maxIterations < 0) {
                return;
            }
            if (++this.iterations > this.maxIterations) {
                throw new InterpreterException.Builder(String.format("Iteration budget exceeded: %d", this.maxIterations), new Object[0]).setErrorCode(CelErrorCode.ITERATION_BUDGET_EXCEEDED).build();
            }
        }

        private IntermediateResult resolveSimpleName(String name, Long exprId) {
            return this.currentResolver.resolveSimpleName(name, exprId);
        }

        private Optional<Object> resolveAttribute(CelAttribute attr) {
            return this.currentResolver.resolveAttribute(attr);
        }

        private void pushScope(ImmutableMap<String, IntermediateResult> scope) {
            RuntimeUnknownResolver.ScopedResolver scopedResolver = this.currentResolver.withScope((Map<String, IntermediateResult>)scope);
            this.currentResolver = scopedResolver;
            this.resolvers.addLast(scopedResolver);
        }

        private void popScope() {
            if (this.resolvers.isEmpty()) {
                throw new IllegalStateException("Execution frame error: more scopes popped than pushed");
            }
            this.resolvers.removeLast();
            this.currentResolver = this.resolvers.getLast();
        }
    }

    @AutoValue
    static abstract class IntermediateResult {
        IntermediateResult() {
        }

        abstract CelAttribute attribute();

        abstract Object value();

        static IntermediateResult create(CelAttribute attr, Object value) {
            Preconditions.checkArgument((!(value instanceof IntermediateResult) ? 1 : 0) != 0, (Object)"Recursive intermediate results are not supported.");
            return new AutoValue_DefaultInterpreter_IntermediateResult(attr, value);
        }

        static IntermediateResult create(Object value) {
            return IntermediateResult.create(CelAttribute.EMPTY, value);
        }
    }
}

