/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.ExprFeatures;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoAdapter;
import dev.cel.common.internal.ProtoMessageFactory;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.expr.Type;
import dev.cel.expr.Value;
import dev.cel.runtime.MessageFactory;
import dev.cel.runtime.RuntimeTypeProvider;
import dev.cel.runtime.StandardTypeResolver;
import dev.cel.runtime.TypeResolver;
import java.util.Map;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@Immutable
@Internal
public final class DescriptorMessageProvider
implements RuntimeTypeProvider {
    private final ProtoMessageFactory protoMessageFactory;
    private final TypeResolver typeResolver;
    private final ProtoAdapter protoAdapter;

    @Deprecated
    public DescriptorMessageProvider(MessageFactory messageFactory) {
        this(messageFactory.toProtoMessageFactory(), CelOptions.LEGACY);
    }

    @Deprecated
    public DescriptorMessageProvider(MessageFactory messageFactory, ImmutableSet<ExprFeatures> features) {
        this(messageFactory.toProtoMessageFactory(), CelOptions.fromExprFeatures(features));
    }

    public DescriptorMessageProvider(ProtoMessageFactory protoMessageFactory, CelOptions celOptions) {
        this.typeResolver = StandardTypeResolver.getInstance(celOptions);
        this.protoMessageFactory = protoMessageFactory;
        this.protoAdapter = new ProtoAdapter(DynamicProto.create(protoMessageFactory), celOptions.enableUnsignedLongs());
    }

    @Override
    public @Nullable Value resolveObjectType(Object obj, @Nullable Value checkedTypeValue) {
        return this.typeResolver.resolveObjectType(obj, checkedTypeValue);
    }

    @Override
    public Value adaptType(CelType type) {
        return this.typeResolver.adaptType(type);
    }

    @Override
    @Deprecated
    public @Nullable Value adaptType(@Nullable Type type) {
        return this.typeResolver.adaptType(type);
    }

    @Override
    public @Nullable Object createMessage(String messageName, Map<String, Object> values) {
        Message.Builder builder = this.protoMessageFactory.newBuilder(messageName).orElseThrow(() -> new CelRuntimeException(new IllegalArgumentException(String.format("cannot resolve '%s' as a message", messageName)), CelErrorCode.ATTRIBUTE_NOT_FOUND));
        try {
            Descriptors.Descriptor descriptor = builder.getDescriptorForType();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = this.findField(descriptor, entry.getKey());
                Optional<Object> fieldValue = this.protoAdapter.adaptValueToFieldType(fieldDescriptor, entry.getValue());
                fieldValue.ifPresent(o -> builder.setField(fieldDescriptor, o));
            }
            return this.protoAdapter.adaptProtoToValue((MessageOrBuilder)builder.build());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public @Nullable Object selectField(Object message, String fieldName) {
        if (message instanceof Optional) {
            Optional optionalMap = (Optional)message;
            if (!optionalMap.isPresent()) {
                return Optional.empty();
            }
            Map unwrappedMap = (Map)optionalMap.get();
            if (!unwrappedMap.containsKey(fieldName)) {
                return Optional.empty();
            }
            return Optional.of(unwrappedMap.get(fieldName));
        }
        if (message instanceof Map) {
            Map map = (Map)message;
            if (map.containsKey(fieldName)) {
                return map.get(fieldName);
            }
            throw new CelRuntimeException(new IllegalArgumentException(String.format("key '%s' is not present in map.", fieldName)), CelErrorCode.ATTRIBUTE_NOT_FOUND);
        }
        MessageOrBuilder typedMessage = DescriptorMessageProvider.assertFullProtoMessage(message);
        Descriptors.FieldDescriptor fieldDescriptor = this.findField(typedMessage.getDescriptorForType(), fieldName);
        if (DescriptorMessageProvider.isWrapperType(fieldDescriptor) && !typedMessage.hasField(fieldDescriptor)) {
            return NullValue.NULL_VALUE;
        }
        Object value = typedMessage.getField(fieldDescriptor);
        return this.protoAdapter.adaptFieldToValue(fieldDescriptor, value).orElse(null);
    }

    @Override
    public Object adapt(Object message) {
        if (message instanceof Message) {
            return this.protoAdapter.adaptProtoToValue((MessageOrBuilder)((Message)message));
        }
        return message;
    }

    @Override
    public Object hasField(Object message, String fieldName) {
        if (message instanceof Optional) {
            Optional optionalMessage = (Optional)message;
            if (!optionalMessage.isPresent()) {
                return false;
            }
            message = optionalMessage.get();
        }
        if (message instanceof Map) {
            Map map = (Map)message;
            return map.containsKey(fieldName);
        }
        MessageOrBuilder typedMessage = DescriptorMessageProvider.assertFullProtoMessage(message);
        Descriptors.FieldDescriptor fieldDescriptor = this.findField(typedMessage.getDescriptorForType(), fieldName);
        if (fieldDescriptor.isRepeated()) {
            return typedMessage.getRepeatedFieldCount(fieldDescriptor) > 0;
        }
        return typedMessage.hasField(fieldDescriptor);
    }

    private Descriptors.FieldDescriptor findField(Descriptors.Descriptor descriptor, String fieldName) {
        Optional<Descriptors.FieldDescriptor> maybeFieldDescriptor;
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(fieldName);
        if (fieldDescriptor == null && (maybeFieldDescriptor = this.protoMessageFactory.getDescriptorPool().findExtensionDescriptor(descriptor, fieldName)).isPresent()) {
            fieldDescriptor = maybeFieldDescriptor.get();
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException(String.format("field '%s' is not declared in message '%s'", fieldName, descriptor.getFullName()));
        }
        return fieldDescriptor;
    }

    private static MessageOrBuilder assertFullProtoMessage(Object candidate) {
        if (!(candidate instanceof MessageOrBuilder)) {
            throw new CelRuntimeException(new IllegalStateException(String.format("[internal] expected an instance of 'com.google.protobuf.MessageOrBuilder' but found '%s'", candidate.getClass().getName())), CelErrorCode.INTERNAL_ERROR);
        }
        return (MessageOrBuilder)candidate;
    }

    private static boolean isWrapperType(Descriptors.FieldDescriptor field) {
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            return false;
        }
        String fieldTypeName = field.getMessageType().getFullName();
        return CelTypes.isWrapperType(fieldTypeName);
    }
}

