/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.runtime.Metadata;
import org.jspecify.nullness.Nullable;

@Internal
public class InterpreterException
extends Exception {
    private final CelErrorCode errorCode;

    public CelErrorCode getErrorCode() {
        return this.errorCode;
    }

    private InterpreterException(String message, Throwable cause, CelErrorCode errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public static class Builder {
        private final String message;
        private @Nullable String location;
        private int position;
        private Throwable cause;
        private CelErrorCode errorCode = CelErrorCode.INTERNAL_ERROR;

        public Builder(String message, Object ... args) {
            this.message = args.length > 0 ? String.format(message, args) : message;
        }

        public Builder(RuntimeException e, String message, Object ... args) {
            if (e instanceof CelRuntimeException) {
                CelRuntimeException celRuntimeException = (CelRuntimeException)e;
                this.errorCode = celRuntimeException.getErrorCode();
                this.cause = e.getCause();
                message = e.getCause().getMessage();
            } else {
                this.cause = e;
            }
            this.message = args.length > 0 ? String.format(message, args) : message;
        }

        @CanIgnoreReturnValue
        public Builder setLocation(@Nullable Metadata metadata, long exprId) {
            if (metadata != null) {
                this.location = metadata.getLocation();
                this.position = metadata.getPosition(exprId);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setErrorCode(CelErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @CheckReturnValue
        public InterpreterException build() {
            return new InterpreterException(String.format("evaluation error%s: %s", this.location != null ? " at " + this.location + ":" + this.position : "", this.message), this.cause, this.errorCode);
        }
    }
}

