/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.cel.common.CelErrorCode;
import dev.cel.common.annotations.Internal;
import dev.cel.expr.ExprValue;
import dev.cel.expr.UnknownSet;
import dev.cel.runtime.IncompleteData;
import dev.cel.runtime.InterpreterException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jspecify.nullness.Nullable;

@Internal
public final class InterpreterUtil {
    public static Object strict(Object valueOrThrowable) throws InterpreterException {
        if (!(valueOrThrowable instanceof Throwable)) {
            return valueOrThrowable;
        }
        if (valueOrThrowable instanceof InterpreterException) {
            throw (InterpreterException)valueOrThrowable;
        }
        if (valueOrThrowable instanceof RuntimeException) {
            throw (RuntimeException)valueOrThrowable;
        }
        throw new RuntimeException((Throwable)valueOrThrowable);
    }

    public static boolean isUnknown(Object obj) {
        return obj instanceof ExprValue && ((ExprValue)obj).getKindCase() == ExprValue.KindCase.UNKNOWN;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public static Object completeDataOnly(Object obj, String exceptionMessage) throws InterpreterException {
        if (obj instanceof IncompleteData) {
            throw new InterpreterException.Builder(exceptionMessage, new Object[0]).setErrorCode(CelErrorCode.INVALID_ARGUMENT).build();
        }
        return obj;
    }

    public static ExprValue combineUnknownExprValue(Object ... objs) {
        UnknownSet.Builder unknownsetBuilder = UnknownSet.newBuilder();
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        for (Object object : objs) {
            if (!InterpreterUtil.isUnknown(object)) continue;
            ids.addAll(((ExprValue)object).getUnknown().getExprsList());
        }
        unknownsetBuilder.addAllExprs(ids);
        return ExprValue.newBuilder().setUnknown(unknownsetBuilder).build();
    }

    public static ExprValue createUnknownExprValue(Long ... ids) {
        return InterpreterUtil.createUnknownExprValue(Arrays.asList(ids));
    }

    public static ExprValue createUnknownExprValue(List<Long> ids) {
        ExprValue.Builder exprValueBuilder = ExprValue.newBuilder();
        exprValueBuilder.setUnknown(UnknownSet.newBuilder().addAllExprs(ids));
        return exprValueBuilder.build();
    }

    public static Object shortcircuitUnknownOrThrowable(Object left, Object right) throws InterpreterException {
        if (InterpreterUtil.isUnknown(left) && InterpreterUtil.isUnknown(right)) {
            return InterpreterUtil.combineUnknownExprValue(left, right);
        }
        if (InterpreterUtil.isUnknown(left)) {
            return left;
        }
        if (InterpreterUtil.isUnknown(right)) {
            return right;
        }
        if (left instanceof Throwable) {
            return InterpreterUtil.strict(left);
        }
        if (right instanceof Throwable) {
            return InterpreterUtil.strict(right);
        }
        throw new RuntimeException("Left or/and right object is neither bool, unknown nor error, unexpected behavior.");
    }

    public static Object valueOrUnknown(@Nullable Object valueOrThrowable, Long id) {
        if (InterpreterUtil.isUnknown(valueOrThrowable)) {
            ExprValue value = (ExprValue)valueOrThrowable;
            if (value.getUnknown().getExprsCount() != 0) {
                return valueOrThrowable;
            }
            return InterpreterUtil.createUnknownExprValue(id);
        }
        if (valueOrThrowable == null) {
            return InterpreterUtil.createUnknownExprValue(id);
        }
        return valueOrThrowable;
    }

    private InterpreterUtil() {
    }
}

