/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import com.google.re2j.Pattern;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.CelRuntimeException;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.Converter;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.internal.ProtoAdapter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.threeten.extra.AmountFormats;

@Internal
public final class RuntimeHelpers {
    private static final java.time.Duration DURATION_MAX = java.time.Duration.ofDays(3652500L);
    private static final java.time.Duration DURATION_MIN = DURATION_MAX.negated();
    public static final Converter<Integer, Long> INT32_TO_INT64 = Integer::longValue;
    public static final Converter<Integer, Long> UINT32_TO_UINT64 = UnsignedInts::toLong;
    public static final Converter<Float, Double> FLOAT_TO_DOUBLE = Float::doubleValue;
    public static final Converter<Long, Integer> INT64_TO_INT32 = Ints::checkedCast;
    public static final Converter<Double, Float> DOUBLE_TO_FLOAT = Double::floatValue;

    public static Duration createDurationFromString(String d) {
        try {
            java.time.Duration dv = AmountFormats.parseUnitBasedDuration((CharSequence)d);
            Preconditions.checkArgument((dv.compareTo(DURATION_MAX) <= 0 && dv.compareTo(DURATION_MIN) >= 0 ? 1 : 0) != 0, (Object)"invalid duration range");
            return Duration.newBuilder().setSeconds(dv.getSeconds()).setNanos(dv.getNano()).build();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("invalid duration format", e);
        }
    }

    public static boolean matches(String string, String regexp) {
        return RuntimeHelpers.matches(string, regexp, CelOptions.newBuilder().disableCelStandardEquality(false).build());
    }

    public static boolean matches(String string, String regexp, CelOptions celOptions) {
        if (!celOptions.enableRegexPartialMatch()) {
            return Pattern.matches((String)regexp, (CharSequence)string);
        }
        return Pattern.compile((String)regexp).matcher((CharSequence)string).find();
    }

    public static Pattern compilePattern(String regexp) {
        return Pattern.compile((String)regexp);
    }

    public static <E> List<E> concat(List<E> first, List<E> second) {
        ArrayList<E> result = new ArrayList<E>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <A> A indexList(List<A> list, Number index) {
        if (index instanceof Double) {
            return (A)RuntimeHelpers.doubleToLongLossless(index.doubleValue()).map(v -> RuntimeHelpers.indexList(list, v)).orElseThrow(() -> new CelRuntimeException(new IndexOutOfBoundsException("Index out of bounds: " + index.doubleValue()), CelErrorCode.INDEX_OUT_OF_BOUNDS));
        }
        int castIndex = Ints.checkedCast((long)index.longValue());
        if (castIndex < 0 || castIndex >= list.size()) {
            throw new CelRuntimeException(new IndexOutOfBoundsException("Index out of bounds: " + castIndex), CelErrorCode.INDEX_OUT_OF_BOUNDS);
        }
        return list.get(castIndex);
    }

    public static long int64Add(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.addExact(x, y);
        }
        return x + y;
    }

    public static long int64Divide(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap() && x == Long.MIN_VALUE && y == -1L) {
            throw new ArithmeticException("most negative number wraps");
        }
        return x / y;
    }

    public static long int64Multiply(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.multiplyExact(x, y);
        }
        return x * y;
    }

    public static long int64Negate(long x, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.negateExact(x);
        }
        return -x;
    }

    public static long int64Subtract(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            return Math.subtractExact(x, y);
        }
        return x - y;
    }

    public static long uint64Add(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap()) {
            if (x < 0L && y < 0L) {
                throw new ArithmeticException("range overflow on unsigned addition");
            }
            long z = x + y;
            if ((x < 0L || y < 0L) && z >= 0L) {
                throw new ArithmeticException("range overflow on unsigned addition");
            }
            return z;
        }
        return x + y;
    }

    public static UnsignedLong uint64Add(UnsignedLong x, UnsignedLong y) {
        if (x.compareTo(UnsignedLong.MAX_VALUE.minus(y)) > 0) {
            throw new ArithmeticException("range overflow on unsigned addition");
        }
        return x.plus(y);
    }

    public static int uint64CompareTo(long x, long y, CelOptions celOptions) {
        return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.compare((long)x, (long)y) : UnsignedLong.valueOf((long)x).compareTo(UnsignedLong.valueOf((long)y));
    }

    public static int uint64CompareTo(long x, long y) {
        return RuntimeHelpers.uint64CompareTo(x, y, CelOptions.LEGACY);
    }

    public static int uint64CompareTo(UnsignedLong x, UnsignedLong y) {
        return x.compareTo(y);
    }

    public static long uint64Divide(long x, long y, CelOptions celOptions) {
        try {
            return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.divide((long)x, (long)y) : UnsignedLong.valueOf((long)x).dividedBy(UnsignedLong.valueOf((long)y)).longValue();
        }
        catch (ArithmeticException e) {
            throw new CelRuntimeException(e, CelErrorCode.DIVIDE_BY_ZERO);
        }
    }

    public static long uint64Divide(long x, long y) {
        return RuntimeHelpers.uint64Divide(x, y, CelOptions.LEGACY);
    }

    public static UnsignedLong uint64Divide(UnsignedLong x, UnsignedLong y) {
        if (y.equals((Object)UnsignedLong.ZERO)) {
            throw new CelRuntimeException(new ArithmeticException("/ by zero"), CelErrorCode.DIVIDE_BY_ZERO);
        }
        return x.dividedBy(y);
    }

    public static long uint64Mod(long x, long y, CelOptions celOptions) {
        try {
            return celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? UnsignedLongs.remainder((long)x, (long)y) : UnsignedLong.valueOf((long)x).mod(UnsignedLong.valueOf((long)y)).longValue();
        }
        catch (ArithmeticException e) {
            throw new CelRuntimeException(e, CelErrorCode.DIVIDE_BY_ZERO);
        }
    }

    public static UnsignedLong uint64Mod(UnsignedLong x, UnsignedLong y) {
        if (y.equals((Object)UnsignedLong.ZERO)) {
            throw new CelRuntimeException(new ArithmeticException("/ by zero"), CelErrorCode.DIVIDE_BY_ZERO);
        }
        return x.mod(y);
    }

    public static long uint64Mod(long x, long y) {
        return RuntimeHelpers.uint64Mod(x, y, CelOptions.LEGACY);
    }

    public static long uint64Multiply(long x, long y, CelOptions celOptions) {
        long z;
        long l = z = celOptions.enableUnsignedComparisonAndArithmeticIsUnsigned() ? x * y : UnsignedLong.valueOf((long)x).times(UnsignedLong.valueOf((long)y)).longValue();
        if (celOptions.errorOnIntWrap() && y != 0L && Long.divideUnsigned(z, y) != x) {
            throw new ArithmeticException("multiply out of unsigned integer range");
        }
        return z;
    }

    public static long uint64Multiply(long x, long y) {
        return RuntimeHelpers.uint64Multiply(x, y, CelOptions.LEGACY);
    }

    public static UnsignedLong uint64Multiply(UnsignedLong x, UnsignedLong y) {
        if (!y.equals((Object)UnsignedLong.ZERO) && x.compareTo(UnsignedLong.MAX_VALUE.dividedBy(y)) > 0) {
            throw new ArithmeticException("multiply out of unsigned integer range");
        }
        return x.times(y);
    }

    public static long uint64Subtract(long x, long y, CelOptions celOptions) {
        if (celOptions.errorOnIntWrap() && (x < 0L && y < 0L && x < y || x >= 0L && y >= 0L && x < y || x >= 0L && y < 0L)) {
            throw new ArithmeticException("unsigned subtraction underflow");
        }
        return x - y;
    }

    public static UnsignedLong uint64Subtract(UnsignedLong x, UnsignedLong y) {
        if (x.compareTo(y) < 0) {
            throw new ArithmeticException("unsigned subtraction underflow");
        }
        return x.minus(y);
    }

    public static <A> Converter<A, A> identity() {
        return value -> value;
    }

    public static Object adaptValue(DynamicProto dynamicProto, Object value, CelOptions celOptions) {
        if (value == null) {
            return NullValue.NULL_VALUE;
        }
        if (value instanceof Number) {
            return RuntimeHelpers.maybeAdaptPrimitive(value);
        }
        if (value instanceof MessageOrBuilder) {
            return RuntimeHelpers.adaptProtoToValue(dynamicProto, (MessageOrBuilder)value, celOptions);
        }
        return value;
    }

    public static Object maybeAdaptPrimitive(Object value) {
        if (value instanceof Optional) {
            Optional optionalVal = (Optional)value;
            if (!optionalVal.isPresent()) {
                return optionalVal;
            }
            return Optional.of(RuntimeHelpers.maybeAdaptPrimitive(optionalVal.get()));
        }
        if (value instanceof Float) {
            return FLOAT_TO_DOUBLE.convert((Float)value);
        }
        if (value instanceof Integer) {
            return INT32_TO_INT64.convert((Integer)value);
        }
        return value;
    }

    public static Object adaptProtoToValue(DynamicProto dynamicProto, MessageOrBuilder obj, CelOptions celOptions) {
        ProtoAdapter protoAdapter = new ProtoAdapter(dynamicProto, celOptions.enableUnsignedLongs());
        if (obj instanceof Message) {
            return protoAdapter.adaptProtoToValue(obj);
        }
        if (obj instanceof Message.Builder) {
            return protoAdapter.adaptProtoToValue((MessageOrBuilder)((Message.Builder)obj).build());
        }
        return obj;
    }

    public static Optional<UnsignedLong> doubleToUnsignedChecked(double v) {
        if (v < 0.0 || Math.getExponent(v) >= 64) {
            return Optional.empty();
        }
        if (v >= Math.scalb(1.0, 63)) {
            v -= Math.scalb(1.0, 64);
        }
        return Optional.of(UnsignedLong.fromLongBits((long)((long)v)));
    }

    public static Optional<Long> doubleToLongChecked(double v) {
        int exp = Math.getExponent(v);
        if (exp >= 63 && v != Math.scalb(-1.0, 63)) {
            return Optional.empty();
        }
        return Optional.of((long)v);
    }

    public static Optional<Long> doubleToLongLossless(Number v) {
        Optional<Long> conv = RuntimeHelpers.doubleToLongChecked(v.doubleValue());
        return conv.map(l -> l.doubleValue() == v.doubleValue() ? l : null);
    }

    private RuntimeHelpers() {
    }
}

