/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelDescriptorPool;
import dev.cel.common.internal.DynamicProto;
import dev.cel.common.types.CelType;
import dev.cel.common.types.TypeType;
import dev.cel.common.values.CelValue;
import dev.cel.common.values.CelValueProvider;
import dev.cel.common.values.ProtoCelValueConverter;
import dev.cel.common.values.SelectableValue;
import dev.cel.common.values.StringValue;
import dev.cel.expr.Type;
import dev.cel.expr.Value;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.RuntimeTypeProvider;
import dev.cel.runtime.StandardTypeResolver;
import dev.cel.runtime.TypeResolver;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jspecify.nullness.Nullable;

@Immutable
@Internal
public final class RuntimeTypeProviderLegacyImpl
implements RuntimeTypeProvider {
    private final CelValueProvider valueProvider;
    private final ProtoCelValueConverter protoCelValueConverter;
    private final TypeResolver standardTypeResolver;

    @VisibleForTesting
    public RuntimeTypeProviderLegacyImpl(CelOptions celOptions, CelValueProvider valueProvider, CelDescriptorPool celDescriptorPool, DynamicProto dynamicProto) {
        this.valueProvider = valueProvider;
        this.protoCelValueConverter = ProtoCelValueConverter.newInstance(celOptions, celDescriptorPool, dynamicProto);
        this.standardTypeResolver = StandardTypeResolver.getInstance(celOptions);
    }

    @Override
    public Object createMessage(String messageName, Map<String, Object> values) {
        return this.unwrapCelValue(this.valueProvider.newValue(messageName, values).orElseThrow(() -> new NoSuchElementException("Could not generate a new value for message name: " + messageName)));
    }

    @Override
    public Object selectField(Object message, String fieldName) {
        SelectableValue selectableValue = (SelectableValue)((Object)this.protoCelValueConverter.fromJavaObjectToCelValue(message));
        return this.unwrapCelValue(selectableValue.select(StringValue.create(fieldName)));
    }

    @Override
    public Object hasField(Object message, String fieldName) {
        SelectableValue selectableValue = (SelectableValue)((Object)this.protoCelValueConverter.fromJavaObjectToCelValue(message));
        return selectableValue.find(StringValue.create(fieldName)).isPresent();
    }

    @Override
    public Object adapt(Object message) {
        if (message instanceof CelUnknownSet) {
            return message;
        }
        return this.unwrapCelValue(this.protoCelValueConverter.fromJavaObjectToCelValue(message));
    }

    @Override
    public Value resolveObjectType(Object obj, Value checkedTypeValue) {
        Preconditions.checkNotNull((Object)checkedTypeValue);
        return this.standardTypeResolver.resolveObjectType(obj, checkedTypeValue);
    }

    @Override
    public Value adaptType(CelType type) {
        Preconditions.checkNotNull((Object)type);
        if (type instanceof TypeType) {
            return RuntimeTypeProviderLegacyImpl.createTypeValue(((TypeType)type).containingTypeName());
        }
        return RuntimeTypeProviderLegacyImpl.createTypeValue(type.name());
    }

    @Override
    public @Nullable Value adaptType(@Nullable Type type) {
        throw new UnsupportedOperationException("This should only be called with native CelType.");
    }

    private Object unwrapCelValue(CelValue object) {
        return this.protoCelValueConverter.fromCelValueToJavaObject(object);
    }

    private static Value createTypeValue(String name) {
        return Value.newBuilder().setTypeValue(name).build();
    }
}

